/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support;

import com.huawei.fitframework.annotation.Order;
import com.huawei.fitframework.broker.client.ioc.FitableDependencyResolver;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.DefaultProxyFactory;
import com.huawei.fitframework.broker.client.support.route.DefaultPreferFilter;
import com.huawei.fitframework.broker.client.support.route.DefaultRuleFilter;
import com.huawei.fitframework.broker.server.BrokerServer;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.ConfigUnit;
import com.huawei.fitframework.conf.ioc.ConfigurationDependencyResolver;
import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.conf.support.DefaultConfig;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentScanner;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.support.ComponentDependencyResolver;
import com.huawei.fitframework.ioc.support.DefaultComponentContainer;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginInstaller;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.plugin.support.DefaultPluginBrief;
import com.huawei.fitframework.plugin.support.DefaultPluginManager;
import com.huawei.fitframework.plugin.support.FrameworkPluginInstaller;
import com.huawei.fitframework.plugin.util.ClassLoaderUtils;
import com.huawei.fitframework.plugin.util.PluginConfigUtils;
import com.huawei.fitframework.runtime.ApplicationInitializer;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.Arguments;
import com.huawei.fitframework.runtime.FitContext;
import com.huawei.fitframework.runtime.FitDebugger;
import com.huawei.fitframework.runtime.FitRuntime;
import com.huawei.fitframework.runtime.FitRuntimeSettings;
import com.huawei.fitframework.runtime.PluginBrief;
import com.huawei.fitframework.runtime.PluginStartedObserver;
import com.huawei.fitframework.runtime.PluginStartingObserver;
import com.huawei.fitframework.runtime.PluginStoppedObserver;
import com.huawei.fitframework.runtime.PluginStoppingObserver;
import com.huawei.fitframework.runtime.SystemDirectories;
import com.huawei.fitframework.runtime.support.DefaultFitContext;
import com.huawei.fitframework.runtime.support.conf.AppNameConfigUnit;
import com.huawei.fitframework.runtime.support.conf.StartupConfigResolver;
import com.huawei.fitframework.runtime.support.conf.StartupConfigUnit;
import com.huawei.fitframework.runtime.support.conf.support.StartupConfigFileResolver;
import com.huawei.fitframework.runtime.support.conf.support.StartupConfigResourceResolver;
import com.huawei.fitframework.system.SystemClassLoaderContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFitRuntime
implements FitRuntime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultFitRuntime.class);
    private static final String VERSION = "2.6.5-RELEASE";
    private static final String SYSTEM_PROPERTY_DEBUG_ENABLED = "debug.enabled";
    private static final String FIT_CONTAINER_TYPE = "fit.container.type";
    private final FitRuntimeSettings settings;

    public DefaultFitRuntime(FitRuntimeSettings settings) {
        this.settings = FitRuntimeSettings.decorateDefault(settings, FitRuntimeSettings.defaultSettings());
    }

    @Override
    public FitContext start() {
        try {
            FitContext context = this.start0();
            log.info("Application started. Total {} milliseconds cost.", (Object)(System.currentTimeMillis() - this.settings.getStartTime()));
            return context;
        }
        catch (Throwable t) {
            log.error("Fail to start fit runtime: {}.", (Object)ExceptionUtils.getReason((Throwable)t));
            log.debug("Fail to start fit runtime.", t);
            throw t;
        }
    }

    private FitContext start0() {
        log.info("Prepare to start fit application. Version: {}.", (Object)VERSION);
        this.printCommandLineArgs();
        log.info("Load framework config.");
        Config config = this.initializeConfig();
        log.info("Initialize components of application.");
        DefaultComponentContainer container = new DefaultComponentContainer((String)ObjectUtils.cast((Object)config.get((Object)this, FIT_CONTAINER_TYPE)));
        DefaultProxyFactory factory = new DefaultProxyFactory((ComponentContainer)container, config);
        DefaultPluginManager pluginManager = new DefaultPluginManager((ComponentContainer)container);
        container.getRegistry().register((Object)config);
        container.getRegistry().register((Object)factory);
        container.getRegistry().register((Object)factory.getBrokerClient());
        container.getRegistry().register((Object)factory.getConfigurationLoader());
        container.getRegistry().register((Object)pluginManager);
        container.getRegistry().register((Object)new DefaultRuleFilter(factory.getBrokerClient()));
        container.getRegistry().register((Object)new DefaultPreferFilter(factory.getBrokerClient()));
        container.addDependencyResolver((DependencyResolver)new ConfigurationDependencyResolver(config, factory.getBrokerClient()));
        container.addDependencyResolver((DependencyResolver)new FitableDependencyResolver(factory.getBrokerClient()));
        container.addDependencyResolver((DependencyResolver)new ComponentDependencyResolver((ComponentContainer)container));
        this.initializeComponentContainer((ComponentContainer)container);
        ClassLoaderUtils.addExtensions();
        log.info("Start FIT platform.");
        this.startFramework((ComponentContainer)container, (PluginManager)pluginManager);
        this.startPlugins((ComponentContainer)container, (PluginManager)pluginManager);
        log.info("Add runtime shutdown handler.");
        this.addShutdownHandler((PluginManager)pluginManager);
        log.info("Initialize application with application initializers.");
        container.list(ApplicationInitializer.class).values().forEach(ApplicationInitializer::initialize);
        log.info("Start broker servers.");
        this.startBrokerServers((ComponentContainer)container);
        log.info("Notify application started.");
        this.notifyApplicationStarted((ComponentContainer)container, (PluginManager)pluginManager);
        this.startDebuggerIfDebugMode((ComponentContainer)container);
        return new DefaultFitContext((ProxyFactory)factory, (ComponentContainer)container);
    }

    private void addShutdownHandler(PluginManager pluginManager) {
        Validation.notNull((Object)pluginManager, (String)"The plugin manager cannot be null.", (Object[])new Object[0]);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> pluginManager.list().forEach(Plugin::stop)));
    }

    private void startFramework(ComponentContainer container, PluginManager pluginManager) {
        FrameworkPluginInstaller frameworkInstaller = new FrameworkPluginInstaller(container, SystemDirectories.framework());
        pluginManager.install((PluginInstaller)frameworkInstaller);
        container.getRegistry().preloadSingletons();
    }

    private void startPlugins(ComponentContainer container, PluginManager pluginManager) {
        Arguments arguments = this.settings.getCommandLineArguments();
        StartupConfig startupConfig = this.readStartupConfig(arguments.getStartupConfigPath());
        List levels = startupConfig.getLevels();
        Collections.sort(levels);
        ArrayList<Plugin> startedPlugins = new ArrayList<Plugin>();
        try {
            Iterator iterator = levels.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                List<Plugin> installedPlugins = this.installPlugins(pluginManager, startupConfig.getPlugins(level));
                log.info("Total {} plugins installed.", (Object)installedPlugins.size());
                installedPlugins.forEach(Plugin::resolve);
                this.startInstalledPlugins(container, startedPlugins, installedPlugins);
            }
        }
        catch (Exception e) {
            this.stopStartedPlugins(container, startedPlugins);
            throw e;
        }
    }

    private void startInstalledPlugins(ComponentContainer container, List<Plugin> startedPlugins, List<Plugin> installedPlugins) {
        log.info("Preload singleton components.");
        installedPlugins.forEach(plugin -> {
            container.list(PluginStartingObserver.class).values().forEach(observer -> observer.onPluginStarting((PluginBrief)new DefaultPluginBrief(plugin.getName(), plugin.getBaseDirectory(), plugin.getLocalFitableIdentities())));
            plugin.start();
            startedPlugins.add((Plugin)plugin);
            container.list(PluginStartedObserver.class).values().forEach(observer -> observer.onPluginStarted((PluginBrief)new DefaultPluginBrief(plugin.getName(), plugin.getBaseDirectory(), plugin.getLocalFitableIdentities())));
        });
    }

    private void stopStartedPlugins(ComponentContainer container, List<Plugin> startedPlugins) {
        for (int i = startedPlugins.size() - 1; i >= 0; --i) {
            Plugin plugin = startedPlugins.get(i);
            container.list(PluginStoppingObserver.class).values().forEach(observer -> observer.onPluginStopping((PluginBrief)new DefaultPluginBrief(plugin.getName(), plugin.getBaseDirectory(), plugin.getLocalFitableIdentities())));
            plugin.stop();
            container.list(PluginStoppedObserver.class).values().forEach(observer -> observer.onPluginStopped((PluginBrief)new DefaultPluginBrief(plugin.getName(), plugin.getBaseDirectory(), plugin.getLocalFitableIdentities())));
        }
    }

    private Config initializeConfig() {
        ConfigUnit argConfig = PluginConfigUtils.resolveArgumentsConfigUnit(this.settings.getCommandLineArguments().getKeyValues());
        AppNameConfigUnit appNameConfig = new AppNameConfigUnit();
        StartupConfigUnit startupConfig = new StartupConfigUnit(this.settings.getStartTime());
        return new DefaultConfig(ConfigUnit.combineConfigUnits((ConfigUnit[])new ConfigUnit[]{argConfig, appNameConfig, startupConfig}));
    }

    private StartupConfig readStartupConfig(String startupConfigPath) {
        Map<String, Object> config = StartupConfigResolver.combine(new StartupConfigFileResolver(startupConfigPath), new StartupConfigResourceResolver(SystemClassLoaderContainer.getSharedClassLoader())).resolve();
        List specifiedSystemPlugins = SystemDirectories.allPlugins().stream().map(plugin -> StartupConfig.Plugin.build().name(plugin.name()).absoluteLocation(plugin.root().getAbsolutePath()).level(0).build()).collect(Collectors.toList());
        return StartupConfig.build(config).addSystemPlugins(specifiedSystemPlugins).build();
    }

    private void notifyApplicationStarted(ComponentContainer container, PluginManager pluginManager) {
        container.list(ApplicationStartedObserver.class).values().stream().sorted(Comparator.comparingInt(this::getFitableOrder)).forEach(observer -> observer.onApplicationStarted(pluginManager.list().stream().map(plugin -> new DefaultPluginBrief(plugin.getName(), plugin.getBaseDirectory(), plugin.getLocalFitableIdentities())).collect(Collectors.toList())));
    }

    private void printCommandLineArgs() {
        Map<String, String> keyValues = this.settings.getCommandLineArguments().getKeyValues();
        log.info("Received {} arguments.", (Object)keyValues.size());
        int count = 0;
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            Validation.isFalse((boolean)entry.getKey().contains(System.lineSeparator()), (String)"Arg[{0}] key contains line separator, exit.", (Object[])new Object[]{count});
            Validation.isFalse((boolean)entry.getValue().contains(System.lineSeparator()), (String)"Arg[{0}] value contains line separator, exit.", (Object[])new Object[]{count});
            log.info("Arg[{}={}]: {}.", new Object[]{count++, entry.getKey(), entry.getValue()});
        }
    }

    private void startBrokerServers(ComponentContainer container) {
        container.get(BrokerServer.class, new Object[0]).map(BrokerServer.class::cast).ifPresent(BrokerServer::startServers);
    }

    private <T> int getFitableOrder(T fitable) {
        return Optional.ofNullable(fitable.getClass().getDeclaredAnnotation(Order.class)).map(Order::value).orElse(0);
    }

    private void startDebuggerIfDebugMode(ComponentContainer container) {
        if (Boolean.getBoolean(SYSTEM_PROPERTY_DEBUG_ENABLED)) {
            log.info("Start fit debugger.");
            container.get(FitDebugger.class, new Object[0]).map(FitDebugger.class::cast).ifPresent(FitDebugger::start);
        }
    }

    private void initializeComponentContainer(ComponentContainer container) {
        ComponentScanner.Factory factory = (ComponentScanner.Factory)ReflectionUtils.instantiate(this.settings.getComponentScannerFactoryClass());
        container.getRegistry().register((Object)factory);
    }

    private List<Plugin> installPlugins(PluginManager pluginManager, List<StartupConfig.Plugin> pluginConfigs) {
        return pluginConfigs.stream().map(plugin -> this.installPlugin(pluginManager, (StartupConfig.Plugin)plugin)).collect(Collectors.toList());
    }

    private Plugin installPlugin(PluginManager pluginManager, StartupConfig.Plugin plugin) {
        log.info("Install plugin in folder: {}", (Object)plugin.file().getPath());
        return pluginManager.install(plugin);
    }
}

