/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support.conf.support;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.PropertiesUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.support.conf.StartupConfigResolver;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupConfigFileResolver
implements StartupConfigResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartupConfigFileResolver.class);
    private final String startupConfigPath;

    public StartupConfigFileResolver(String startupConfigPath) {
        this.startupConfigPath = startupConfigPath;
    }

    @Override
    public Map<String, Object> resolve() {
        if (StringUtils.isBlank((String)this.startupConfigPath)) {
            log.info("No startup config file, skip loading.");
            return Collections.emptyMap();
        }
        File startupConfigFile = FileUtils.canonicalize((String)this.startupConfigPath);
        if (startupConfigFile.isFile()) {
            return PropertiesUtils.mapFrom((File)startupConfigFile);
        }
        log.info("Fail to load startup config file. [startupConfigPath={}]", (Object)this.startupConfigPath);
        return Collections.emptyMap();
    }
}

