/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support.conf.support;

import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.PropertiesUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.runtime.support.conf.StartupConfigResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupConfigResourceResolver
implements StartupConfigResolver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StartupConfigResourceResolver.class);
    private static final String[] DEFAULT_STARTUP_RESOURCE_NAMES = new String[]{"fit_startup.properties", "fit-startup.properties"};
    private final ClassLoader classLoader;

    public StartupConfigResourceResolver(ClassLoader classLoader) {
        this.classLoader = (ClassLoader)Validation.notNull((Object)classLoader, (String)"No class loader.", (Object[])new Object[0]);
    }

    @Override
    public Map<String, Object> resolve() {
        for (String defaultStartupResourceName : DEFAULT_STARTUP_RESOURCE_NAMES) {
            Map<String, Object> config = this.resolve(defaultStartupResourceName);
            if (!MapUtils.isNotEmpty(config)) continue;
            return config;
        }
        return Collections.emptyMap();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> resolve(String resourceName) {
        try (InputStream in = this.classLoader.getResourceAsStream(resourceName);){
            Map map = in != null ? PropertiesUtils.mapFrom((InputStream)in) : Collections.emptyMap();
            return map;
        }
        catch (IOException e) {
            log.error("Fail to load startup config resource. [classLoader={}, resource={}]", (Object)this.classLoader, (Object)resourceName);
            return Collections.emptyMap();
        }
    }
}

