/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support.plugin;

import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.support.DefaultComponentRegistry;
import com.huawei.fitframework.plugin.support.DefaultPluginBrief;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.PluginBrief;
import com.huawei.fitframework.runtime.plugin.PluginContext;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultPluginContext
implements PluginContext {
    private static final String GENERICABLE_CONFIG_RESOURCE_KEY = "fit.properties";
    private final ProxyFactory factory;
    private final ComponentContainer container;

    public DefaultPluginContext(ProxyFactory factory, ComponentContainer container) {
        this.factory = factory;
        this.container = container;
    }

    public void addPlugin(String pluginName, List<Object> fitableObjects) {
        DefaultComponentRegistry registry = new DefaultComponentRegistry(this.container, pluginName);
        this.container.installRegistry((ComponentRegistry)registry);
        fitableObjects.forEach(obj -> registry.register(obj.getClass().getName(), obj));
        List bundleIdentities = this.factory.getLocalProxyRepository(pluginName).map(ProxyRepository::getFitableIdentities).orElse(Collections.emptyList());
        DefaultPluginBrief pluginBrief = new DefaultPluginBrief(pluginName, FileUtils.canonicalize((File)new File(".")), bundleIdentities);
        this.container.list(ApplicationStartedObserver.class).values().forEach(arg_0 -> DefaultPluginContext.lambda$addPlugin$1((PluginBrief)pluginBrief, arg_0));
    }

    public void addConfiguration(ClassLoader classLoader) {
        BrokerConfigurationConfigurator configurator = BrokerConfigurationConfigurator.embedded((ClassLoader)classLoader, (String)GENERICABLE_CONFIG_RESOURCE_KEY, (ConfigurationReader)ConfigurationReader.properties());
        configurator.configure((ConfigurableBrokerConfiguration)ObjectUtils.cast((Object)this.factory.getConfigurationLoader().load()), ConfigureMode.APPEND);
    }

    public void registerGenericables(Set<Class<?>> genericableClasses) {
        ProxyFactory proxyFactory = (ProxyFactory)this.container.require(ProxyFactory.class, new Object[0]);
        genericableClasses.forEach(arg_0 -> ((ProxyFactory)proxyFactory).registerGenericable(arg_0));
    }

    private static /* synthetic */ void lambda$addPlugin$1(PluginBrief pluginBrief, ApplicationStartedObserver observer) {
        observer.onApplicationStarted(Collections.singletonList(pluginBrief));
    }
}

