/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support.proxy;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.runtime.proxy.ProxyContext;
import java.lang.reflect.Field;
import java.util.Collections;

public class DefaultProxyContext
implements ProxyContext {
    private static final String GENERICABLE_RESOURCE_PREFIX = "fit.public.genericables.";
    private final ProxyFactory factory;
    private final ComponentContainer container;

    public DefaultProxyContext(ProxyFactory factory, ComponentContainer container) {
        this.factory = factory;
        this.container = container;
    }

    public Object getFitProxy(Object bean, String beanName, Field field) {
        Class<?> genericableClass = field.getType();
        if (genericableClass == BrokerClient.class) {
            return this.container.get(BrokerClient.class, new Object[0]).orElseThrow(() -> new IllegalStateException("No BrokerClient."));
        }
        this.factory.registerGenericable(genericableClass);
        this.downloadGenericableConfigurations(genericableClass);
        return this.resolveDependency(bean, beanName, field);
    }

    private void downloadGenericableConfigurations(Class<?> genericableClass) {
        String genericableId = AnnotationUtils.getGenericableId(genericableClass);
        String genericablePath = GENERICABLE_RESOURCE_PREFIX + genericableId;
        ConfigCenterClient configClient = (ConfigCenterClient)this.factory.getBrokerClient().getProxy(ConfigCenterClient.class);
        ConfigCenterListener configCenterListener = (ConfigCenterListener)this.factory.getBrokerClient().getProxy(ConfigCenterListener.class);
        String appName = (String)ObjectUtils.cast((Object)((Config)this.container.require(Config.class, new Object[0])).get((Object)this, "app.name"));
        configClient.subscribe(StringUtils.format((String)"{0}:genericables", (Object[])new Object[]{appName}), genericablePath);
        configClient.download(Collections.singletonList(genericablePath), (arg_0, arg_1) -> ((ConfigCenterListener)configCenterListener).onPropertiesChanged(arg_0, arg_1));
    }

    public Object getConfigValue(Object bean, String beanName, Field field) {
        return this.resolveDependency(bean, beanName, field);
    }

    private Object resolveDependency(Object bean, String beanName, Field field) {
        return this.container.getDependencyResolver().resolve(ComponentBrief.builder().setComponentName(beanName).setComponentClass(bean.getClass()).setStereotype("singleton").build(), bean, field).getValue();
    }
}

