/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.util;

import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.runtime.Arguments;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArgumentUtils {
    private static final String KEY_STARTUP_CONFIG_PATH = "startup.config.path";
    private static final String KEY_FRAMEWORK_DIRECTORY = "framework.directory";
    private static final String KEY_FRAMEWORK_LOG_CONFIG_PATH = "framework.log.config-file";
    private static final String KEY_EXTENSION_DIRECTORIES = "extension.directories";
    private static final String KEY_PLUGIN_DIRECTORIES = "plugin.directories";
    private static final String SEPARATOR_KEY_VALUE = "=";
    private static final char SEPARATOR_VALUE = ',';

    private ArgumentUtils() {
    }

    public static Arguments resolve(String[] args) {
        if (ArrayUtils.isEmpty((Object[])args)) {
            return Arguments.builder().build();
        }
        return ArgumentUtils.createArguments(args);
    }

    private static Arguments createArguments(String[] args) {
        Map<String, String> argsMap = Stream.of(args).filter(StringUtils::isNotBlank).filter(arg -> arg.contains(SEPARATOR_KEY_VALUE)).map(arg -> arg.split(SEPARATOR_KEY_VALUE)).filter(argSplits -> ((String[])argSplits).length == 2).collect(Collectors.toMap(argSplits -> argSplits[0], argSplits -> StringUtils.trim((String)argSplits[1])));
        return Arguments.builder().frameworkDirectory(argsMap.get(KEY_FRAMEWORK_DIRECTORY)).extensionDirectories(ArgumentUtils.splitValue(argsMap.get(KEY_EXTENSION_DIRECTORIES))).pluginDirectories(ArgumentUtils.splitValue(argsMap.get(KEY_PLUGIN_DIRECTORIES))).startupConfigPath(argsMap.get(KEY_STARTUP_CONFIG_PATH)).logConfigFile(argsMap.get(KEY_FRAMEWORK_LOG_CONFIG_PATH)).keyValues(argsMap).build();
    }

    private static Collection<String> splitValue(String value) {
        if (StringUtils.isBlank((String)value)) {
            return Collections.emptyList();
        }
        return StringUtils.splitToList((String)value, (char)',').stream().filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
    }
}

