/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.serialization.yaml.snakeyaml;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.serialization.YamlSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

@Fitable
public class SnakeYamlSerializer
implements YamlSerializer {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> deserialize(File file) {
        Validation.notNull((Object)file, (String)"The file of yaml to deserialize cannot be null.", (Object[])new Object[0]);
        if (!file.exists()) return Collections.emptyMap();
        try (FileInputStream in = new FileInputStream(file);){
            Map<String, Object> map = this.deserialize(in);
            return map;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Fail to deserialize from yaml", ex);
        }
    }

    public Map<String, Object> deserialize(InputStream in) {
        Validation.notNull((Object)in, (String)"The input stream that contains yaml to deserialize cannot be null.", (Object[])new Object[0]);
        Yaml yaml = new Yaml();
        return (Map)yaml.load(in);
    }
}

