/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.inspection.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.inspection.entity.InspectionActiveResult;
import com.huawei.yinglong.distributed.inspection.entity.InspectionParams;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ExportReport;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.Inspect;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryInspectOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class InspectionExternalTask {
    private static final Logger log = LoggerFactory.getLogger(InspectionExternalTask.class);
    @Fit
    private ExportReport exportReport;
    private String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;
    @Fit
    private Inspect inspect;
    @Fit
    private QueryInspectOverview queryInspectOverview;

    public InspectionExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startInspection")
    @Bean
    public ExternalTaskHandler startInspection() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            InspectionParams params = this.bpmContextService.getContext(executionId, InspectionParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            Response response = this.inspect.process(params.getInspectParams());
            InspectionActiveResult activeResult = new InspectionActiveResult();
            if (!ResponseUtil.isSuccess((Response)response)) {
                activeResult.setStatus(ResultStatus.FAILED);
                activeResult.setDescription(response.getResult().getDescription());
                this.bpmContextService.updateActivityResult(executionId, activeResult);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            activeResult.setStatus(ResultStatus.SUCCESS);
            this.bpmContextService.setProgress(executionId, 100);
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        };
    }

    @ExternalTaskSubscription(value="InspectionOverview", lockDuration=3000L)
    @Bean
    public ExternalTaskHandler queryInspectionOverview() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            InspectionParams params = this.bpmContextService.getContext(executionId, InspectionParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            Response response = this.queryInspectOverview.process(params.getTaskId());
            InspectionActiveResult result = InspectionActiveResult.buildInspectionActiveResult((TaskOverviewDTO)response.getData());
            this.bpmContextService.updateActivityResult(executionId, result);
            this.bpmContextService.setProgress(executionId, (int)result.getProgress());
            this.generateReportWhenFinish(executionId, params.getTaskId(), result);
            this.updateActiveStatus(externalTask, externalTaskService, result);
        };
    }

    private void generateReportWhenFinish(String executionId, String taskId, InspectionActiveResult result) {
        if (!result.getStatus().isFinished()) {
            return;
        }
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        Response exportRes = this.exportReport.process(taskId, processConfig.getReportDir());
        log.info("export result: {}", (Object)exportRes);
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, InspectionActiveResult result) {
        ResultStatus status = result.getStatus();
        if (!status.isFinished()) {
            return;
        }
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }
}

