/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.inspection.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.inspection.entity.InspectionParams;
import com.huawei.yinglong.distributed.inspection.entity.VersionCheckActiveResult;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.SubmitMatchCheckTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryHardwareEvaluationOverview;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiHardwareEvaluationOverview;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class VersionCheckExternalTask {
    private static final Logger log = LoggerFactory.getLogger(VersionCheckExternalTask.class);
    @Fit(alias="queryHardwareEvaluationOverview\u7684\u5b9e\u73b0")
    private QueryHardwareEvaluationOverview queryHardwareEvaluationOverview;
    private final String workerId;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private SubmitMatchCheckTask submitMatchCheckTask;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ExportWithScene exportWithScene;

    public VersionCheckExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startVersionCheck")
    @Bean
    public ExternalTaskHandler startVersionCheck() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            InspectionParams params = this.bpmContextService.getContext(executionId, InspectionParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            if (params.getVersionCheckParams() == null) {
                log.info("inspect params is null, do not need execute.");
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            try {
                Response response = this.submitMatchCheckTask.process(params.getVersionCheckParams());
                if (response.getResult().getCode() != 0) {
                    throw new FitException(response.getResult().getDescription());
                }
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
            catch (FitException fitException) {
                log.error("start task failed", (Throwable)fitException);
                this.bpmContextService.updateActivityResult(executionId, new VersionCheckActiveResult());
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    @ExternalTaskSubscription(value="versionOverview")
    @Bean
    public ExternalTaskHandler queryVersionOverview() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            try {
                Response response = this.queryHardwareEvaluationOverview.process(externalTask.getProcessInstanceId());
                VersionCheckActiveResult result = VersionCheckActiveResult.buildVersionCheckActiveResult((MultiHardwareEvaluationOverview)response.getData());
                this.bpmContextService.updateActivityResult(executionId, result);
                this.bpmContextService.setProgress(executionId, (int)result.getProgress());
                InspectionParams params = this.bpmContextService.getContext(executionId, InspectionParams.class);
                this.generateReportWhenFinish(executionId, params.getTaskId(), result);
                this.updateActiveStatus(externalTask, externalTaskService, result);
            }
            catch (FitException fitException) {
                log.error("query exec failed", (Throwable)fitException);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private void generateReportWhenFinish(String executionId, String taskId, VersionCheckActiveResult result) {
        if (!result.getStatus().isFinished()) {
            return;
        }
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        Response exportRes = this.exportWithScene.process(taskId, processConfig.getReportDir(), "quality_check");
        log.info("export version check report result: {}", (Object)exportRes);
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, VersionCheckActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }
}

