/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.inspection.controller;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.yinglong.distributed.inspection.entity.Inspector;
import com.huawei.yinglong.distributed.inspection.entity.ParseExcelParam;
import com.huawei.yinglong.distributed.inspection.entity.ReportParams;
import com.huawei.yinglong.drop.entity.item.entity.MultiRunningDetailDTO;
import com.huawei.yinglong.drop.entity.item.entity.ResultDetailDTO;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateVersionMapping;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.UpdateVersionMappingParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ParseSwitchLoginExcel;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ParseDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthBmc;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthOs;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiBmcAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiOsAuthParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.BatchDeleteSwitchs;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ConfigSwitchPorts;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ExportReport;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.GetExpandSupportVersion;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.LoginSwitch;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryClusterNodes;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemResultDetail;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemRunningDetail;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItems;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QuerySwitchs;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.UpdateDevOsIp;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.device.entity.ClusterTreeNodesDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.ConfigSwitchPortsParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.DeleteSwitchParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.QueryClusterNodesParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.QueryItemParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SupportVersionDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchLoginParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchResponseDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.UpdateOsIpParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.item.entity.DeviceCheckItemTreeNodeDTO;
import com.huawei.yinglong.smartkit.base.util.ResponseUtil;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"yinglong/inspection"})
public class InspectionController {
    private static final Logger log = LoggerFactory.getLogger(InspectionController.class);
    private static final String NAME_REGEX = "[a-zA-Z\\u4e00-\\u9fa5\\u002a\\u00b7\\s]{1,128}";
    private static final int NORMAL_CODE = 0;
    @Fit
    private ExportReport exportVersionCheck;
    @Fit
    private ExportReport exportReport;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Fit
    private BatchAuthOs batchAuthOs;
    @Fit
    private BatchAuthBmc batchAuthBmc;
    @Fit(alias="queryItemResultDetail\u7684\u5b9e\u73b0")
    private QueryItemResultDetail queryItemResultDetail;
    @Fit
    private QueryItemRunningDetail queryItemRunningDetail;
    @Fit(alias="queryItems\u7684\u5b9e\u73b0")
    private QueryItems queryItems;
    @Fit
    private QueryClusterNodes queryClusterNodes;
    @Fit(alias="queryDevice\u7684\u5b9e\u73b0")
    private QueryDevice queryDevice;
    @Fit(alias="\u5de1\u68c0\u7684\u5b9e\u73b0")
    private LoginSwitch loginSwitch;
    @Fit(alias="\u5de1\u68c0\u7684\u5b9e\u73b0")
    private QuerySwitchs querySwitchs;
    @Fit(alias="\u5de1\u68c0\u7684\u5b9e\u73b0")
    private ConfigSwitchPorts configSwitchPorts;
    @Fit(alias="\u5de1\u68c0\u5220\u9664\u4ea4\u6362\u673a\u7684\u5b9e\u73b0")
    private BatchDeleteSwitchs batchDeleteSwitchs;
    @Fit(alias="updateDevOsIp\u7684\u5b9e\u73b0")
    private UpdateDevOsIp updateDevOsIp;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ParseSwitchLoginExcel parseSwitchLoginExcel;
    @Fit
    private GetExpandSupportVersion getExpandSupportVersion;
    @Fit(alias="updateVersionMapping\u7684\u5b9e\u73b0")
    private UpdateVersionMapping updateVersionMapping;

    @GetMapping(value={"device"})
    public Response<MultiStroageNodeDto> queryDevice(String taskId, String scene) {
        return this.queryDevice.process(taskId, scene);
    }

    @GetMapping(value={"device/nodes"})
    public Response<ClusterTreeNodesDTO> queryClusterNodes(String taskId, String devId) {
        return this.queryClusterNodes.process(QueryClusterNodesParams.builder().taskId(taskId).devId(devId).build());
    }

    @PostMapping(value={"device/nodes/bmc"})
    public Response<String> batchAuthBmc(@RequestBody MultiBmcAuthParams params) {
        log.info("[inspection] start to batch auth bmc, params : {}.", (Object)params);
        Response response = this.batchAuthBmc.process(params);
        log.info("[inspection] start to batch auth bmc, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"device/nodes/os"})
    public Response<String> batchAuthOs(@RequestBody MultiOsAuthParams params) {
        log.info("[inspection] start to batch auth os, params : {}.", (Object)params);
        Response response = this.batchAuthOs.process(params);
        log.info("[inspection] end to batch auth os, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"items"})
    public Response<DeviceCheckItemTreeNodeDTO> queryItems(String taskId, String devId, String scene) {
        return this.queryItems.process(QueryItemParams.builder().taskId(taskId).devId(devId).scene(scene).build());
    }

    @GetMapping(value={"items/detail"})
    public Response<MultiRunningDetailDTO> queryItemRunningDetail(String taskId, String devId) {
        return this.queryItemRunningDetail.process(taskId, devId);
    }

    @GetMapping(value={"item/detail"})
    public Response<ResultDetailDTO> queryQueryItemResultDetail(String taskId, String devId, String itemId) {
        return this.queryItemResultDetail.process(taskId, devId, itemId);
    }

    @GetMapping(value={"version/detail"})
    public Response<MultiDeployTaskDetail> queryVersionCheckRunningDetail(String taskId, String devId) {
        QueryTaskDetailParam param = QueryTaskDetailParam.builder().taskId(String.join((CharSequence)"_", taskId, devId)).subTaskIds(Collections.singletonList("version_check")).build();
        return this.queryTaskDetail.process(param);
    }

    @PostMapping(value={"report"})
    public Response<String> exportReport(@RequestBody ReportParams params) {
        log.info("[inspection] start to export report, params : {}.", (Object)params);
        Response response = this.exportReport.process(params.getTaskId(), params.getTargetDir());
        log.info("[inspection] end to export report, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"version/report"})
    public Response<String> exportVersionCheckReport(@RequestBody ReportParams params) {
        log.info("[inspection] start to export version check report, params : {}.", (Object)params);
        Response response = this.exportVersionCheck.process(params.getTaskId(), params.getTargetDir());
        log.info("[inspection] start to export version check report, result : {}.", (Object)response);
        return response;
    }

    @PutMapping(value={"version/mapping"})
    public Response<ParseDetail> updateVersionMapping(@RequestBody UpdateVersionMappingParam param) {
        log.info("[inspection] start to update version mapping, params : {}.", (Object)param);
        Response response = this.updateVersionMapping.process(param);
        log.info("[inspection] end to update version mapping, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"qualityCheckUser"})
    public Response<String> saveBureauInspector(@RequestBody Inspector inspector) {
        String qualityCheckUser = inspector.getInspector();
        log.info("[inspection] start to save bureau inspector, size : {}.", (Object)qualityCheckUser.length());
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{qualityCheckUser}) && qualityCheckUser.matches(NAME_REGEX)) {
            System.setProperty("qualityCheckUser", qualityCheckUser);
            log.info("[inspection] success to save bureau inspector.");
            return ResponseUtil.success();
        }
        log.info("[inspection] failed to save bureau inspector.");
        return ResponseUtil.failed((String)"", (String)"");
    }

    @GetMapping(value={"qualityCheckUser"})
    public Response<String> queryBureauInspector() {
        return ResponseUtil.success((Object)StringUtils.defaultString((String)System.getProperty("qualityCheckUser")));
    }

    @PostMapping(value={"loginSwitch"})
    public Response<String> loginSwitch(@RequestBody SwitchLoginParam switchLoginParam) {
        log.info("[inspection] start to login switch, params : {}.", (Object)switchLoginParam);
        Response response = this.loginSwitch.process(switchLoginParam);
        log.info("[inspection] end to login switch, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"device/update-os-ip"})
    public Response<Boolean> updateOsIp(@RequestBody UpdateOsIpParam param) {
        log.info("[inspection] start to update os ip, params : {}.", (Object)param);
        Response response = this.updateDevOsIp.process(param);
        log.info("[inspection] end to update os ip, result : {}.", (Object)response);
        return response;
    }

    @GetMapping(value={"querySwitches/{taskId}/{floatIp}"})
    public Response<SwitchResponseDTO> querySwitches(@PathVariable String taskId, @PathVariable String floatIp) {
        return this.querySwitchs.process(taskId, floatIp);
    }

    @PostMapping(value={"configPorts"})
    public Response<String> configPorts(@RequestBody ConfigSwitchPortsParam configSwitchPortsParam) {
        log.info("[inspection] start to config ports, params : {}.", (Object)configSwitchPortsParam);
        Response response = this.configSwitchPorts.process(configSwitchPortsParam);
        log.info("[inspection] end to config ports, result : {}.", (Object)response);
        return response;
    }

    @DeleteMapping(value={"batchRemoveSwitches"})
    public Response<String> batchRemoveSwitches(@RequestBody DeleteSwitchParam deleteSwitchParam) {
        log.info("[inspection] start to batch remove switches, params : {}.", (Object)deleteSwitchParam);
        Response response = this.batchDeleteSwitchs.process(deleteSwitchParam);
        log.info("[inspection] end to batch remove switches, result : {}.", (Object)response);
        return response;
    }

    @PostMapping(value={"batchImportSwitch"})
    public Response<String> batchImportSwitches(@RequestBody ParseExcelParam params) {
        log.info("[inspection] start to batch import switches, params : {}.", (Object)params);
        Response parseResult = this.parseSwitchLoginExcel.process(params.getTaskId(), params.getFloatIp(), params.getFilePath());
        log.info("[inspection] end to batch import switches, result : {}.", (Object)parseResult);
        if (parseResult.getResult().getCode() != 0) {
            return this.buildNewResponse((Response<SwitchLoginParam>)parseResult);
        }
        return this.loginSwitch((SwitchLoginParam)parseResult.getData());
    }

    private Response<String> buildNewResponse(Response<SwitchLoginParam> parseResult) {
        Response response = new Response();
        response.setResult(parseResult.getResult());
        return response;
    }

    @GetMapping(value={"support-list"})
    private Response<SupportVersionDTO> getExpandSupportDevice(String expansionScene, String supportInspectType) {
        return ResponseUtil.success((Object)this.getExpandSupportVersion.process(expansionScene, supportInspectType));
    }
}

