/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.inspection.entity;

import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckdDevOverviewDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import java.util.List;
import java.util.stream.Collectors;

public class InspectionActiveResult
extends ActivityResult {
    private List<CheckdDevOverviewDTO> overviews;
    private TaskStatistics taskStatistics;
    private double progress;
    private String description;
    private ResultStatus status;

    public static InspectionActiveResult buildInspectionActiveResult(TaskOverviewDTO overviewDTO) {
        return ((InspectionActiveResultBuilder)((InspectionActiveResultBuilder)((InspectionActiveResultBuilder)((InspectionActiveResultBuilder)InspectionActiveResult.builder().progress(overviewDTO.getProgress())).status(ResultStatus.of((String)overviewDTO.getStatus(), (ResultStatus)ResultStatus.WAITED))).overviews(overviewDTO.getOverviews())).taskStatistics(InspectionActiveResult.builderTaskStatistics(InspectionActiveResult.collectOverviewStatus(overviewDTO.getOverviews())))).build();
    }

    private static List<ResultStatus> collectOverviewStatus(List<CheckdDevOverviewDTO> overviewVos) {
        return overviewVos.stream().map(CheckdDevOverviewDTO::getStatus).map(status -> ResultStatus.of((String)status, (ResultStatus)ResultStatus.FAILED)).collect(Collectors.toList());
    }

    private static TaskStatistics builderTaskStatistics(List<ResultStatus> statuses) {
        return TaskStatistics.builder().successNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isSuccess).count())).failedNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isFailed).count())).noExecutedNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isWaiting).count())).runningNum(Integer.valueOf((int)statuses.stream().filter(ResultStatus::isRunning).count())).build();
    }

    protected InspectionActiveResult(InspectionActiveResultBuilder<?, ?> b) {
        super(b);
        this.overviews = ((InspectionActiveResultBuilder)b).overviews;
        this.taskStatistics = ((InspectionActiveResultBuilder)b).taskStatistics;
        this.progress = ((InspectionActiveResultBuilder)b).progress;
        this.description = ((InspectionActiveResultBuilder)b).description;
        this.status = ((InspectionActiveResultBuilder)b).status;
    }

    public static InspectionActiveResultBuilder<?, ?> builder() {
        return new InspectionActiveResultBuilderImpl();
    }

    public List<CheckdDevOverviewDTO> getOverviews() {
        return this.overviews;
    }

    public TaskStatistics getTaskStatistics() {
        return this.taskStatistics;
    }

    public double getProgress() {
        return this.progress;
    }

    public String getDescription() {
        return this.description;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public void setOverviews(List<CheckdDevOverviewDTO> overviews) {
        this.overviews = overviews;
    }

    public void setTaskStatistics(TaskStatistics taskStatistics) {
        this.taskStatistics = taskStatistics;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    public InspectionActiveResult() {
    }

    public InspectionActiveResult(List<CheckdDevOverviewDTO> overviews, TaskStatistics taskStatistics, double progress, String description, ResultStatus status) {
        this.overviews = overviews;
        this.taskStatistics = taskStatistics;
        this.progress = progress;
        this.description = description;
        this.status = status;
    }

    public String toString() {
        return "InspectionActiveResult(overviews=" + this.getOverviews() + ", taskStatistics=" + this.getTaskStatistics() + ", progress=" + this.getProgress() + ", description=" + this.getDescription() + ", status=" + this.getStatus() + ")";
    }

    private static final class InspectionActiveResultBuilderImpl
    extends InspectionActiveResultBuilder<InspectionActiveResult, InspectionActiveResultBuilderImpl> {
        private InspectionActiveResultBuilderImpl() {
        }

        @Override
        protected InspectionActiveResultBuilderImpl self() {
            return this;
        }

        @Override
        public InspectionActiveResult build() {
            return new InspectionActiveResult(this);
        }
    }

    public static abstract class InspectionActiveResultBuilder<C extends InspectionActiveResult, B extends InspectionActiveResultBuilder<C, B>>
    extends ActivityResult.ActivityResultBuilder<C, B> {
        private List<CheckdDevOverviewDTO> overviews;
        private TaskStatistics taskStatistics;
        private double progress;
        private String description;
        private ResultStatus status;

        public B overviews(List<CheckdDevOverviewDTO> overviews) {
            this.overviews = overviews;
            return (B)this.self();
        }

        public B taskStatistics(TaskStatistics taskStatistics) {
            this.taskStatistics = taskStatistics;
            return (B)this.self();
        }

        public B progress(double progress) {
            this.progress = progress;
            return (B)this.self();
        }

        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        public B status(ResultStatus status) {
            this.status = status;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "InspectionActiveResult.InspectionActiveResultBuilder(super=" + super.toString() + ", overviews=" + this.overviews + ", taskStatistics=" + this.taskStatistics + ", progress=" + this.progress + ", description=" + this.description + ", status=" + this.status + ")";
        }
    }
}

