/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.impl;

import io.nats.client.JetStreamApiException;
import io.nats.client.JetStreamReader;
import io.nats.client.JetStreamSubscription;
import io.nats.client.Message;
import io.nats.client.PullRequestOptions;
import io.nats.client.api.ConsumerInfo;
import io.nats.client.impl.MessageManager;
import io.nats.client.impl.NatsConnection;
import io.nats.client.impl.NatsDispatcher;
import io.nats.client.impl.NatsJetStream;
import io.nats.client.impl.NatsMessage;
import io.nats.client.impl.NatsSubscription;
import io.nats.client.support.NatsJetStreamConstants;
import java.io.IOException;
import java.time.Duration;
import java.util.Iterator;
import java.util.List;

public class NatsJetStreamSubscription
extends NatsSubscription
implements JetStreamSubscription,
NatsJetStreamConstants {
    public static final String SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL = "Subscription type does not support pull.";
    protected final NatsJetStream js;
    protected String stream;
    protected String consumerName;
    protected MessageManager[] managers;
    protected static final long MIN_MILLIS = 20L;
    protected static final long EXPIRE_LESS_MILLIS = 10L;

    NatsJetStreamSubscription(String sid, String subject, String queueName, NatsConnection connection, NatsDispatcher dispatcher, NatsJetStream js, String stream, String consumer, MessageManager[] managers) {
        super(sid, subject, queueName, connection, dispatcher);
        this.js = js;
        this.stream = stream;
        this.consumerName = consumer;
        this.managers = managers;
        for (MessageManager mm : managers) {
            mm.startup(this);
        }
    }

    void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    String getConsumerName() {
        return this.consumerName;
    }

    String getStream() {
        return this.stream;
    }

    boolean isPullMode() {
        return false;
    }

    MessageManager[] getManagers() {
        return this.managers;
    }

    @Override
    void invalidate() {
        for (MessageManager mm : this.managers) {
            mm.shutdown();
        }
        super.invalidate();
    }

    @Override
    public Message nextMessage(Duration timeout) throws InterruptedException, IllegalStateException {
        if (timeout == null || timeout.toMillis() <= 0L) {
            return this._nextUnmanagedNullOrLteZero(timeout);
        }
        return this._nextUnmanaged(timeout.toMillis());
    }

    @Override
    public Message nextMessage(long timeoutMillis) throws InterruptedException, IllegalStateException {
        if (timeoutMillis <= 0L) {
            return this._nextUnmanagedNullOrLteZero(Duration.ZERO);
        }
        return this._nextUnmanaged(timeoutMillis);
    }

    protected Message _nextUnmanagedNullOrLteZero(Duration timeout) throws InterruptedException {
        NatsMessage msg = this.nextMessageInternal(timeout);
        while (msg != null && this.anyManaged(msg)) {
            msg = this.nextMessageInternal(timeout);
        }
        return msg;
    }

    protected Message _nextUnmanaged(long timeout) throws InterruptedException {
        long elapsed = 0L;
        long start = System.currentTimeMillis();
        while (elapsed < timeout) {
            NatsMessage msg = this.nextMessageInternal(Duration.ofMillis(Math.max(20L, timeout - elapsed)));
            if (msg == null) {
                return null;
            }
            if (!this.anyManaged(msg)) {
                return msg;
            }
            elapsed = System.currentTimeMillis() - start;
        }
        return null;
    }

    boolean anyManaged(Message msg) {
        for (MessageManager mm : this.managers) {
            if (!mm.manage(msg)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void pull(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pull(PullRequestOptions pullRequestOptions) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullNoWait(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, Duration expiresIn) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public void pullExpiresIn(int batchSize, long expiresInMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public List<Message> fetch(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, Duration maxWait) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public Iterator<Message> iterate(int batchSize, long maxWaitMillis) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public JetStreamReader reader(int batchSize, int repullAt) {
        throw new IllegalStateException(SUBSCRIPTION_TYPE_DOES_NOT_SUPPORT_PULL);
    }

    @Override
    public ConsumerInfo getConsumerInfo() throws IOException, JetStreamApiException {
        return this.js.lookupConsumerInfo(this.stream, this.consumerName);
    }

    public String toString() {
        return "NatsJetStreamSubscription{consumer='" + this.consumerName + '\'' + ", stream='" + this.stream + '\'' + ", deliver='" + this.getSubject() + '\'' + ", isPullMode=" + this.isPullMode() + '}';
    }
}

