/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.hardware.entity.BmcConfigActiveResult;
import com.huawei.yinglong.distributed.hardware.entity.HardwareConfigParam;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.task.entity.entity.TaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.ExportWithScene;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.QueryTaskStatistics;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.SubmitBmcConfigTask;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.ConfigDataParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.MultiDeployTaskDetail;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.entity.entity.QueryTaskDetailParam;
import com.huawei.yinglong.river.deploy.storage.distribution.deployhelper.service.QueryTaskDetail;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryHardwareEvaluationOverview;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class BmcConfigExternalTask {
    private static final Logger log = LoggerFactory.getLogger(BmcConfigExternalTask.class);
    private static final List<String> SUBTASK_IDS = Collections.singletonList("config_ibmc");
    @Fit(alias="queryTaskStatistics\u7684\u5b9e\u73b0")
    private QueryTaskStatistics queryTaskStatistics;
    @Fit(alias="queryTaskDetail\u7684\u5b9e\u73b0")
    private QueryTaskDetail queryTaskDetail;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private ExportWithScene exportWithScene;
    @Fit(alias="queryHardwareEvaluationOverview\u7684\u5b9e\u73b0")
    private QueryHardwareEvaluationOverview queryHardwareEvaluationOverview;
    @Fit(alias="\u90e8\u7f72\u52a9\u624b\u7684\u5b9e\u73b0")
    private SubmitBmcConfigTask submitBmcConfigTask;
    private String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public BmcConfigExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startIBmcConfig")
    @Bean
    public ExternalTaskHandler startIBmcConfig() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            ConfigDataParam bmcConfigParam = this.bpmContextService.getContext(executionId, HardwareConfigParam.class).getBmcConfigParam();
            if (Objects.isNull(bmcConfigParam)) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            bmcConfigParam.setSubTaskIds(SUBTASK_IDS);
            bmcConfigParam.setTaskId(bmcConfigParam.getTaskId() + "_default");
            try {
                Response<String> response = this.submitBmcConfigTask.process(bmcConfigParam);
                if (response.getResult().getCode() != 0) {
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
            }
            catch (FitException fitException) {
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        };
    }

    @ExternalTaskSubscription(value="bmcConfigOverView", lockDuration=3000L)
    @Bean
    public ExternalTaskHandler queryBmcConfigOverview() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            ConfigDataParam bmcConfigParam = this.bpmContextService.getContext(executionId, HardwareConfigParam.class).getBmcConfigParam();
            if (Objects.isNull(bmcConfigParam)) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            try {
                QueryTaskDetailParam build = QueryTaskDetailParam.builder().taskId(bmcConfigParam.getTaskId() + "_default").subTaskIds(SUBTASK_IDS).build();
                Response<MultiDeployTaskDetail> detailResponse = this.queryTaskDetail.process(build);
                Response<TaskStatistics> statisticsResponse = this.queryTaskStatistics.process(bmcConfigParam.getTaskId() + "_default", SUBTASK_IDS.get(0));
                BmcConfigActiveResult result = this.buildBmcNetWorkInitResult(statisticsResponse.getData(), detailResponse.getData(), bmcConfigParam);
                this.bpmContextService.updateActivityResult(executionId, result);
                this.bpmContextService.setProgress(executionId, (int)result.getProgress());
                this.generateReportWhenFinish(executionId, bmcConfigParam.getTaskId(), result);
                this.updateActiveStatus(externalTask, externalTaskService, result);
            }
            catch (FitException fitException) {
                log.error("query exec failed", fitException);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    private void generateReportWhenFinish(String executionId, String taskId, BmcConfigActiveResult result) {
        if (!result.getStatus().isFinished()) {
            return;
        }
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        Response<String> exportRes = this.exportWithScene.process(taskId, processConfig.getReportDir(), "bmc_config");
        log.info("export version check report result: {}", (Object)exportRes);
    }

    private BmcConfigActiveResult buildBmcNetWorkInitResult(TaskStatistics statistics, MultiDeployTaskDetail details, ConfigDataParam param) {
        BmcConfigExternalTask.resetDetails(details);
        return ((BmcConfigActiveResult.BmcConfigActiveResultBuilder)((BmcConfigActiveResult.BmcConfigActiveResultBuilder)((BmcConfigActiveResult.BmcConfigActiveResultBuilder)((BmcConfigActiveResult.BmcConfigActiveResultBuilder)BmcConfigActiveResult.builder().progress(details.getDetail().getProgress())).overviews(details.getDeployTaskDetails())).status(this.updateStatus(statistics, param))).statistics(statistics)).build();
    }

    private static void resetDetails(MultiDeployTaskDetail details) {
        if (details.getDeployTaskDetails() == null) {
            return;
        }
        details.getDeployTaskDetails().forEach(deployTaskDetailVo -> deployTaskDetailVo.setStepTaskDetails(Collections.emptyList()));
    }

    private ResultStatus updateStatus(TaskStatistics statistics, ConfigDataParam param) {
        int totalNum = param.getDevUids().size();
        int finishedNum = statistics.getSuccessNum() + statistics.getFailedNum();
        if (finishedNum < totalNum) {
            return ResultStatus.RUNNING;
        }
        if (statistics.getSuccessNum() == totalNum) {
            return ResultStatus.SUCCESS;
        }
        if (statistics.getFailedNum() == totalNum) {
            return ResultStatus.FAILED;
        }
        return ResultStatus.PART_SUCCESS;
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, BmcConfigActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }
}

