/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.bpm;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.distributed.hardware.entity.HardwareConfigParam;
import java.util.Objects;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class HardwareUpgradeExternalTask {
    private static final Logger log = LoggerFactory.getLogger(HardwareUpgradeExternalTask.class);
    private String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public HardwareUpgradeExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startHardwareUpgrade")
    @Bean
    public ExternalTaskHandler startHardwareUpgrade() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            HardwareConfigParam context = this.bpmContextService.getContext(executionId, HardwareConfigParam.class);
            if (Objects.isNull(context.getUpgradeParam())) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        };
    }

    @ExternalTaskSubscription(value="hardwareUpgradeOverview", lockDuration=3000L)
    @Bean
    public ExternalTaskHandler queryHardwareUpgradeOverview() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            HardwareConfigParam context = this.bpmContextService.getContext(executionId, HardwareConfigParam.class);
            if (Objects.isNull(context.getUpgradeParam())) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        };
    }
}

