/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.bpm;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.hardware.entity.CollectActiveResult;
import com.huawei.yinglong.distributed.hardware.entity.HardwareConfigParam;
import com.huawei.yinglong.distributed.hardware.entity.InfoCollectParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.CollectLldInfo;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.QueryTaskOverView;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectLldDevParam;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectDevOverViewDTO;
import java.util.Objects;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.spring.boot.starter.ClientProperties;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.client.task.ExternalTaskService;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class InfoCollectExternalTask {
    private static final Logger log = LoggerFactory.getLogger(InfoCollectExternalTask.class);
    @Fit(alias="queryTaskOverView_hardware")
    private QueryTaskOverView queryTaskOverView;
    @Fit(alias="collectLldInfo_hardware")
    private CollectLldInfo collectLldInfo;
    private String workerId;
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    public InfoCollectExternalTask(ClientProperties properties, RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.workerId = properties.getWorkerId();
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }

    @ExternalTaskSubscription(value="startInfoCollect")
    @Bean
    public ExternalTaskHandler startInfoCollect() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            InfoCollectParam infoCollectParam = this.bpmContextService.getContext(executionId, HardwareConfigParam.class).getInfoCollectParam();
            if (Objects.isNull(infoCollectParam)) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            this.collectLldInfo.process(this.transCollectHardwarePara(executionId, infoCollectParam));
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
        };
    }

    private CollectLldDevParam transCollectHardwarePara(String executionId, InfoCollectParam infoCollectParam) {
        ProcessConfig processConfig = (ProcessConfig)this.runtimeService.getVariable(executionId, "context");
        return CollectLldDevParam.builder().taskId(infoCollectParam.getTaskId()).devIds(infoCollectParam.getDevUids()).resultDir(processConfig.getReportDir()).build();
    }

    @ExternalTaskSubscription(value="infoCollectOverview", lockDuration=3000L)
    @Bean
    public ExternalTaskHandler queryInfoCollectOverview() {
        return (externalTask, externalTaskService) -> {
            String executionId = externalTask.getExecutionId();
            InfoCollectParam infoCollectParam = this.bpmContextService.getContext(executionId, HardwareConfigParam.class).getInfoCollectParam();
            if (Objects.isNull(infoCollectParam)) {
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                return;
            }
            MultiCollectDevOverViewDTO overView = this.queryTaskOverView.process(infoCollectParam.getTaskId()).getData();
            ActivityResult activeResult = ((CollectActiveResult.CollectActiveResultBuilder)((CollectActiveResult.CollectActiveResultBuilder)((CollectActiveResult.CollectActiveResultBuilder)CollectActiveResult.builder().progress(CollectActiveResult.calcProgress(overView))).status(CollectActiveResult.mergeStatus(overView))).overView(overView)).build();
            this.bpmContextService.updateActivityResult(executionId, activeResult);
            this.bpmContextService.setProgress(executionId, (int)((CollectActiveResult)activeResult).getProgress());
            this.updateActiveStatus(externalTask, externalTaskService, (CollectActiveResult)activeResult);
        };
    }

    private void updateActiveStatus(ExternalTask externalTask, ExternalTaskService externalTaskService, CollectActiveResult result) {
        ResultStatus status = result.getStatus();
        if (status.isSuccess()) {
            this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            return;
        }
        if (status.isFailed()) {
            this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
        }
    }
}

