/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.entity;

import com.huawei.yinglong.bpm.dto.ActivityResult;
import com.huawei.yinglong.distributed.entity.ResultStatus;
import com.huawei.yinglong.distributed.util.ProgressUtil;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.CollectDevOverViewDTO;
import com.huawei.yinglong.river.infocollect.storage.distribution.collect.entity.MultiCollectDevOverViewDTO;
import java.util.stream.Collectors;

public class CollectActiveResult
extends ActivityResult {
    private double progress;
    private ResultStatus status;
    private MultiCollectDevOverViewDTO overView;

    public static ResultStatus mergeStatus(MultiCollectDevOverViewDTO overView) {
        return ResultStatus.merge(overView.getCollectDevOverViewDTO().stream().map(CollectDevOverViewDTO::getStatus).map(status -> ResultStatus.of(status, ResultStatus.WAITED)).collect(Collectors.toList()));
    }

    public static double calcProgress(MultiCollectDevOverViewDTO overView) {
        return ProgressUtil.averageProgress(overView.getCollectDevOverViewDTO().stream().map(CollectDevOverViewDTO::getProgress).collect(Collectors.toList()));
    }

    protected CollectActiveResult(CollectActiveResultBuilder<?, ?> b) {
        super(b);
        this.progress = ((CollectActiveResultBuilder)b).progress;
        this.status = ((CollectActiveResultBuilder)b).status;
        this.overView = ((CollectActiveResultBuilder)b).overView;
    }

    public static CollectActiveResultBuilder<?, ?> builder() {
        return new CollectActiveResultBuilderImpl();
    }

    public double getProgress() {
        return this.progress;
    }

    public ResultStatus getStatus() {
        return this.status;
    }

    public MultiCollectDevOverViewDTO getOverView() {
        return this.overView;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public void setStatus(ResultStatus status) {
        this.status = status;
    }

    public void setOverView(MultiCollectDevOverViewDTO overView) {
        this.overView = overView;
    }

    public CollectActiveResult(double progress, ResultStatus status, MultiCollectDevOverViewDTO overView) {
        this.progress = progress;
        this.status = status;
        this.overView = overView;
    }

    public CollectActiveResult() {
    }

    public String toString() {
        return "CollectActiveResult(progress=" + this.getProgress() + ", status=" + (Object)((Object)this.getStatus()) + ", overView=" + this.getOverView() + ")";
    }

    private static final class CollectActiveResultBuilderImpl
    extends CollectActiveResultBuilder<CollectActiveResult, CollectActiveResultBuilderImpl> {
        private CollectActiveResultBuilderImpl() {
        }

        @Override
        protected CollectActiveResultBuilderImpl self() {
            return this;
        }

        @Override
        public CollectActiveResult build() {
            return new CollectActiveResult(this);
        }
    }

    public static abstract class CollectActiveResultBuilder<C extends CollectActiveResult, B extends CollectActiveResultBuilder<C, B>>
    extends ActivityResult.ActivityResultBuilder<C, B> {
        private double progress;
        private ResultStatus status;
        private MultiCollectDevOverViewDTO overView;

        public B progress(double progress) {
            this.progress = progress;
            return (B)this.self();
        }

        public B status(ResultStatus status) {
            this.status = status;
            return (B)this.self();
        }

        public B overView(MultiCollectDevOverViewDTO overView) {
            this.overView = overView;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "CollectActiveResult.CollectActiveResultBuilder(super=" + super.toString() + ", progress=" + this.progress + ", status=" + (Object)((Object)this.status) + ", overView=" + this.overView + ")";
        }
    }
}

