/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.listener;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.distributed.hardware.entity.HardwareConfigParam;
import java.util.HashMap;
import java.util.Objects;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HardwareConfigListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(HardwareConfigListener.class);
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    @Override
    public void notify(DelegateExecution execution) throws Exception {
        if (this.hasNoContextVariables(execution)) {
            return;
        }
        String processInstanceId = execution.getProcessInstanceId();
        HardwareConfigParam context = this.bpmContextService.getContext(processInstanceId, HardwareConfigParam.class);
        HashMap<String, Boolean> activityCondition = new HashMap<String, Boolean>();
        activityCondition.put("bmcConfig", Objects.nonNull(context.getBmcConfigParam()));
        activityCondition.put("hardwareUpgrade", Objects.nonNull(context.getUpgradeParam()));
        activityCondition.put("infoCollect", Objects.nonNull(context.getInfoCollectParam()));
        activityCondition.put("biosConfig", Objects.nonNull(context.getBiosConfigParam()));
        this.runtimeService.setVariable(processInstanceId, "conditionVar", activityCondition);
    }

    private boolean hasNoContextVariables(DelegateExecution execution) {
        return Objects.isNull(execution.getVariables()) || !execution.getVariables().containsKey("context");
    }

    public HardwareConfigListener(RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }
}

