/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.hardware.service;

import com.huawei.encryptbase.utils.AesEncryptUtils;
import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.util.CryptUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HardwareConfigCryptService
implements BpmCryptService {
    private static final Logger log = LoggerFactory.getLogger(HardwareConfigCryptService.class);
    private static final String KEY_BIOS_CONFIG_PARAMS = "biosConfigParam";
    private static final List<String> cryptBiosConfigFields = Arrays.asList("biosConfigParam#biosInfos#oldPassword", "biosConfigParam#biosInfos#newPassword");
    private static final String KEY_BMC_CONFIG_PARAMS = "bmcConfigParam";
    private static final List<String> cryptBmcConfigFields = Arrays.asList("bmcConfigParam#patchUser#password", "bmcConfigParam#patchUser#oem#Huawei#snmpV3PrivPasswd", "bmcConfigParam#patchUser#oem#Public#snmpV3PrivPasswd", "bmcConfigParam#deleteUser#password", "bmcConfigParam#deleteUser#oem#Huawei#snmpV3PrivPasswd", "bmcConfigParam#deleteUser#oem#Public#snmpV3PrivPasswd", "bmcConfigParam#postUser#password", "bmcConfigParam#postUser#oem#Huawei#snmpV3PrivPasswd", "bmcConfigParam#postUser#oem#Public#snmpV3PrivPasswd");
    private boolean isSupportCrypt;

    @Override
    public boolean encryptProcessBusiness(Map<String, Object> business) {
        return this.cryptProcessBusiness(business, AesEncryptUtils::encryptByAes);
    }

    @Override
    public boolean decryptProcessBusiness(Map<String, Object> business) {
        return this.cryptProcessBusiness(business, AesEncryptUtils::decryptByAes);
    }

    @Value(value="${smartkit.crypt.enable:false}")
    public void setSupportCrypt(boolean supportCrypt) {
        this.isSupportCrypt = supportCrypt;
    }

    private boolean cryptProcessBusiness(Map<String, Object> business, UnaryOperator<String> cryptor) {
        if (!this.isSupportCrypt || business == null || business.isEmpty()) {
            log.warn("not need to crypt, support : {}.", (Object)this.isSupportCrypt);
            return false;
        }
        if (business.containsKey(KEY_BIOS_CONFIG_PARAMS)) {
            cryptBiosConfigFields.forEach(field -> CryptUtil.cryptSpecialField(business, field, cryptor));
            log.info("crypt bios config params finish.");
        }
        if (business.containsKey(KEY_BMC_CONFIG_PARAMS)) {
            cryptBmcConfigFields.forEach(field -> CryptUtil.cryptSpecialField(business, field, cryptor));
            log.info("crypt bmc config params finish.");
        }
        return true;
    }
}

