/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin;

import com.huawei.fit.hakuna.kernel.loadbalance.FilterV3;
import com.huawei.fit.hakuna.kernel.loadbalance.LoadBalanceV2;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Address;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fit.sdk.context.GetGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class FitLoadBalance {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitLoadBalance.class);
    private static final String PROTOCOL_TEMPLATE = "protocol:{0}";
    private static final char ENVIRONMENT_SEQUENCE_SEPARATOR = ',';
    private static final String SPECIFIED_ENVIRONMENT = "FIT-ENVIRONMENT";
    private static final String SPECIFIED_ENVIRONMENT_GENERICABLE_ID = "FIT-ENVIRONMENT-GENERICABLE-ID";
    private final GetGlobalContext getGlobalContext;
    private final RemoveGlobalContext removeGlobalContext;
    private final ProxyFactory proxyFactory;
    private final ConfigurationLoader configurationLoader;
    private final Deque<String> environmentPrioritySequence;
    private final Map<String, Integer> fitableKeyPositionMap = new ConcurrentHashMap<String, Integer>();

    public FitLoadBalance(@Fit GetGlobalContext getGlobalContext, @Fit RemoveGlobalContext removeGlobalContext, @Fit ProxyFactory proxyFactory, @Fit ConfigurationLoader configurationLoader, @Value(value="${worker.environment}") String environment, @Value(value="${worker.environment-sequence}") String environmentSequence) {
        this.getGlobalContext = getGlobalContext;
        this.removeGlobalContext = removeGlobalContext;
        this.proxyFactory = proxyFactory;
        this.configurationLoader = configurationLoader;
        Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        log.info("Config worker.environment is {}.", (Object)environment);
        Validation.notBlank((String)environmentSequence, (String)"No environment sequence. [config=worker.environment-sequence]", (Object[])new Object[0]);
        log.info("Config worker.environment-sequence is {}.", (Object)environmentSequence);
        this.environmentPrioritySequence = new LinkedList<String>(StringUtils.splitToList((String)environmentSequence, (char)','));
        if (!this.environmentPrioritySequence.contains(environment)) {
            this.environmentPrioritySequence.addFirst(environment);
        }
        log.info("Actually environment sequence is {}.", this.environmentPrioritySequence);
    }

    @com.huawei.fitframework.annotation.Fitable(generic=FilterV3.class, id="3de1d0e89098456da47536d3a5146d4a")
    public List<ApplicationInstance> filterV3(Fitable fitable, List<ApplicationInstance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            log.warn("No instances, return empty. [fitable={}]", (Object)fitable);
            return Collections.emptyList();
        }
        Optional<String> firstEnvironment = this.getFirstMatchedEnvironment(fitable, instances);
        if (!firstEnvironment.isPresent()) {
            log.warn("No endpoints match the environment sequence. [fitable={}, sequence={}]", (Object)fitable, this.environmentPrioritySequence);
            return Collections.emptyList();
        }
        log.info("Environment is matched. [fitable={}, environment={}]", (Object)fitable, (Object)firstEnvironment.get());
        return instances.stream().filter(Objects::nonNull).filter(instance -> CollectionUtils.isNotEmpty((Collection)instance.getWorkers())).map(instance -> this.buildFilteredInstance((String)firstEnvironment.get(), (ApplicationInstance)instance)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ApplicationInstance> buildFilteredInstance(String environment, ApplicationInstance instance) {
        List filteredWorkers = instance.getWorkers().stream().filter(Objects::nonNull).filter(worker -> Objects.equals(worker.getEnvironment(), environment)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filteredWorkers)) {
            return Optional.empty();
        }
        instance.setWorkers(filteredWorkers);
        return Optional.of(instance);
    }

    private Optional<String> getFirstMatchedEnvironment(Fitable fitable, List<ApplicationInstance> instances) {
        Optional<String> specifiedEnvironment = this.getSpecifiedEnvironment(fitable);
        if (specifiedEnvironment.isPresent()) {
            log.info("Environment is specified. [fitable={}, environment={}]", (Object)fitable, (Object)specifiedEnvironment.get());
            return specifiedEnvironment;
        }
        return this.environmentPrioritySequence.stream().filter(environment -> this.containEnvironment(instances, (String)environment)).findFirst();
    }

    private Optional<String> getSpecifiedEnvironment(Fitable fitable) {
        try {
            String genericableId = this.getGlobalContext.process(SPECIFIED_ENVIRONMENT_GENERICABLE_ID);
            if (StringUtils.isBlank((String)genericableId)) {
                return Optional.empty();
            }
            if (Objects.equals(genericableId, fitable.getGenericableId())) {
                String specifiedEnvironment = this.getGlobalContext.process(SPECIFIED_ENVIRONMENT);
                this.clearSpecifiedEnvironment();
                log.info("Specify environment. [environment={}]", (Object)specifiedEnvironment);
                return Optional.ofNullable(specifiedEnvironment);
            }
            log.debug("Specify environment, but not target genericable, skip. [currentGenericable={}, targetGenericable={}]", (Object)fitable.getGenericableId(), (Object)genericableId);
            return Optional.empty();
        }
        catch (Exception e) {
            log.warn("Fail to get specified environment, return empty.", (Throwable)e);
            return Optional.empty();
        }
    }

    private boolean containEnvironment(List<ApplicationInstance> instances, String environment) {
        return instances.stream().filter(applicationInstance -> CollectionUtils.isNotEmpty((Collection)applicationInstance.getWorkers())).anyMatch(applicationInstance -> this.matchTheEnvironment(environment, (ApplicationInstance)applicationInstance));
    }

    private boolean matchTheEnvironment(String environment, ApplicationInstance applicationInstance) {
        return applicationInstance.getWorkers().stream().filter(Objects::nonNull).map(Worker::getEnvironment).anyMatch(env -> Objects.equals(env, environment));
    }

    private void clearSpecifiedEnvironment() {
        try {
            this.removeGlobalContext.process(SPECIFIED_ENVIRONMENT);
            this.removeGlobalContext.process(SPECIFIED_ENVIRONMENT_GENERICABLE_ID);
        }
        catch (Exception e) {
            log.warn("Fail to remove specified environment.", (Throwable)e);
        }
    }

    @com.huawei.fitframework.annotation.Fitable(generic=LoadBalanceV2.class, id="f57b4d578fb845ba8f460fd3afd8dcca")
    public ApplicationInstance loadBalanceV2(Fitable fitable, ApplicationInstance sourceInstance, List<ApplicationInstance> targetInstances) {
        Validation.notNull((Object)fitable, (String)"No fitable info.", (Object[])new Object[0]);
        Validation.notNull((Object)sourceInstance, (String)"No source application instance.", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(targetInstances)) {
            return null;
        }
        return this.findLocal(sourceInstance, targetInstances).orElseGet(() -> this.roundRobinSelect(fitable, this.toSupportedInstances(sourceInstance, targetInstances)));
    }

    private List<ApplicationInstance> toSupportedInstances(ApplicationInstance sourceInstance, List<ApplicationInstance> targetInstances) {
        return targetInstances.stream().filter(applicationInstance -> this.isFormatsSupported(sourceInstance, (ApplicationInstance)applicationInstance)).filter(applicationInstance -> CollectionUtils.isNotEmpty((Collection)applicationInstance.getWorkers())).map(this::toProtocolSupportedInstance).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private boolean isFormatsSupported(ApplicationInstance sourceInstance, ApplicationInstance applicationInstance) {
        if (CollectionUtils.isEmpty((Collection)sourceInstance.getFormats()) || CollectionUtils.isEmpty((Collection)applicationInstance.getFormats())) {
            return false;
        }
        return sourceInstance.getFormats().stream().anyMatch(format -> applicationInstance.getFormats().contains(format));
    }

    private Optional<ApplicationInstance> toProtocolSupportedInstance(ApplicationInstance instance) {
        List workers = instance.getWorkers().stream().filter(worker -> CollectionUtils.isNotEmpty((Collection)worker.getAddresses())).map(this::toProtocolSupportedWorker).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(workers)) {
            return Optional.empty();
        }
        instance.setWorkers(workers);
        return Optional.of(instance);
    }

    private Optional<Worker> toProtocolSupportedWorker(Worker worker) {
        List addresses = worker.getAddresses().stream().filter(address -> CollectionUtils.isNotEmpty((Collection)address.getEndpoints())).map(this::toProtocolSupportedAddress).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(addresses)) {
            return Optional.empty();
        }
        worker.setAddresses(addresses);
        return Optional.of(worker);
    }

    private Optional<Address> toProtocolSupportedAddress(Address address) {
        List endpoints = address.getEndpoints().stream().filter(Objects::nonNull).filter(endpoint -> this.isProtocolSupported(endpoint.getProtocol())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(endpoints)) {
            return Optional.empty();
        }
        address.setEndpoints(endpoints);
        return Optional.of(address);
    }

    private boolean isProtocolSupported(int protocol) {
        String protocolTag = StringUtils.format((String)PROTOCOL_TEMPLATE, (Object[])new Object[]{protocol});
        return this.proxyFactory.listLocalFitableIds("47a8ec8a3d8f46daa1f2d751ad7d6d16").stream().anyMatch(fitableId -> this.isTagDefinedOnFitable(protocolTag, (String)fitableId));
    }

    private boolean isTagDefinedOnFitable(String protocolTag, String fitableId) {
        try {
            return this.configurationLoader.load().fitable("47a8ec8a3d8f46daa1f2d751ad7d6d16", fitableId).filter(fitable -> fitable.tags().contains(protocolTag)).isPresent();
        }
        catch (Exception e) {
            log.warn("Fail to get tag. [genericableId={}, fitableId={}, tag={}]", new Object[]{"47a8ec8a3d8f46daa1f2d751ad7d6d16", fitableId, protocolTag});
            return false;
        }
    }

    private ApplicationInstance roundRobinSelect(Fitable fitable, List<ApplicationInstance> targetInstances) {
        if (CollectionUtils.isEmpty(targetInstances)) {
            return null;
        }
        int targetWorkersSize = targetInstances.stream().map(ApplicationInstance::getWorkers).mapToInt(Collection::size).sum();
        String key = fitable.getGenericableId() + fitable.getFitableId();
        Integer position = this.fitableKeyPositionMap.getOrDefault(key, -1);
        position = (position + 1) % targetWorkersSize;
        this.fitableKeyPositionMap.put(key, position);
        return this.getSelectedInstance(position, targetInstances);
    }

    private ApplicationInstance getSelectedInstance(Integer workerPosition, List<ApplicationInstance> targetInstances) {
        int instanceIndex;
        Integer position = workerPosition;
        for (instanceIndex = 0; instanceIndex < targetInstances.size(); ++instanceIndex) {
            ApplicationInstance applicationInstance = targetInstances.get(instanceIndex);
            if (position - applicationInstance.getWorkers().size() < 0) break;
            position = position - applicationInstance.getWorkers().size();
        }
        ApplicationInstance selectInstance = targetInstances.get(instanceIndex);
        Worker worker = (Worker)selectInstance.getWorkers().get(position);
        selectInstance.setWorkers(Collections.singletonList(worker));
        return selectInstance;
    }

    private Optional<ApplicationInstance> findLocal(ApplicationInstance sourceInstance, List<ApplicationInstance> targetInstances) {
        return targetInstances.stream().filter(Objects::nonNull).filter(targetInstance -> this.contains(sourceInstance, (ApplicationInstance)targetInstance)).findFirst();
    }

    private boolean contains(ApplicationInstance sourceInstance, ApplicationInstance targetInstance) {
        Validation.isTrue((sourceInstance.getWorkers().size() == 1 ? 1 : 0) != 0, (String)"The worker size of source is not 1", (Object[])new Object[0]);
        Worker sourceWorker = (Worker)sourceInstance.getWorkers().iterator().next();
        if (CollectionUtils.isEmpty((Collection)targetInstance.getWorkers())) {
            return false;
        }
        return targetInstance.getWorkers().stream().filter(Objects::nonNull).anyMatch(worker -> Objects.equals(sourceWorker.getId(), worker.getId()));
    }
}

