/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.dto;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import org.camunda.bpm.engine.impl.pvm.runtime.ActivityInstanceState;

public enum ProcessStatus {
    NO_START,
    RUNNING,
    PAUSE,
    FINISHED,
    SUCCEED,
    FAILED;

    private static final EnumSet<ProcessStatus> END_STATUS;

    public static ProcessStatus from(int instanceState) {
        if (instanceState == ActivityInstanceState.DEFAULT.getStateCode()) {
            return RUNNING;
        }
        if (instanceState == ActivityInstanceState.ENDING.getStateCode() || instanceState == ActivityInstanceState.SCOPE_COMPLETE.getStateCode()) {
            return SUCCEED;
        }
        if (instanceState == ActivityInstanceState.CANCELED.getStateCode()) {
            return FAILED;
        }
        return RUNNING;
    }

    public static ProcessStatus from(String status) {
        if ("ACTIVE".equals(status)) {
            return RUNNING;
        }
        if ("SUSPENDED".equals(status)) {
            return PAUSE;
        }
        if ("EXTERNALLY_TERMINATED".equals(status) || "INTERNALLY_TERMINATED".equals(status)) {
            return FAILED;
        }
        if ("COMPLETED".equals(status)) {
            return FINISHED;
        }
        return RUNNING;
    }

    public static boolean canBeDeletedStatus(ProcessStatus status) {
        return status != RUNNING;
    }

    public static boolean needMergeStatus(ProcessStatus status) {
        return status != NO_START;
    }

    public static boolean isEndStatus(ProcessStatus status) {
        return status == FINISHED || status == FAILED || status == PAUSE || status == SUCCEED;
    }

    public static ProcessStatus of(String status, ProcessStatus defaultStatus) {
        return Arrays.stream(ProcessStatus.values()).filter(processStatus -> Objects.equals(processStatus.name(), status)).findFirst().orElse(defaultStatus);
    }

    public boolean isEnd() {
        return END_STATUS.contains((Object)this);
    }

    static {
        END_STATUS = EnumSet.of(FAILED, FINISHED, SUCCEED);
    }
}

