/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.engine;

import com.huawei.encryptbase.exception.ProcessEncryptException;
import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.constant.BpmConstants;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessActivityQueryDto;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.engine.BpmnExtension;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.smartkit.base.util.ObjectMapperUtils;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.camunda.bpm.client.task.ExternalTask;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CamundaEngineServiceImpl
implements BpmEngineService {
    private static final Logger log = LoggerFactory.getLogger(CamundaEngineServiceImpl.class);
    public static final Object VARIABLE_TASK_LOCK = new Object();
    private static final String MULTI_INSTANCE_BODY = "#multiInstanceBody";
    private final ProcessEngine processEngine;
    private final RuntimeService runtimeService;
    private final HistoryService historyService;
    private final ExternalTaskService externalTaskService;
    private final BpmCryptService cryptService;

    @Override
    public String createProcessInstance(String processDefineKey) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processDefineKey);
        return processInstance.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteProcessInstance(List<String> instanceIds) {
        List<String> runningInstanceIds = instanceIds.stream().filter(this::isInstanceNotFinished).collect(Collectors.toList());
        Object object = VARIABLE_TASK_LOCK;
        synchronized (object) {
            runningInstanceIds.forEach(instanceId -> this.runtimeService.removeVariable(instanceId, "context"));
            this.runtimeService.deleteProcessInstancesIfExists(instanceIds, "0", false, false, false);
            this.processEngine.getHistoryService().deleteHistoricProcessInstances(instanceIds);
        }
    }

    private boolean isInstanceNotFinished(String instanceId) {
        return this.queryProcessInstance(instanceId).getStatus() != ProcessStatus.FINISHED;
    }

    @Override
    public void changeProcessInstanceReadOnly(List<String> defineKeys) {
        List<ProcessInstanceDto> processInstances = defineKeys.stream().map(this::queryAllProcessInstance).flatMap(Collection::stream).collect(Collectors.toList());
        processInstances.stream().filter(this::isNotFinishedProcessInstance).forEach(instance -> {
            try {
                this.runtimeService.suspendProcessInstanceById(instance.getId());
                this.runtimeService.setVariable(instance.getId(), "status", (Object)ProcessStatus.FAILED);
            }
            catch (Exception e) {
                log.warn("Update instance {} to readonly failed.", (Object)instance.getId());
            }
        });
        processInstances.forEach(instance -> {
            try {
                this.setProcessInstanceReadOnly(instance.getId());
            }
            catch (Exception e) {
                log.warn("Update instance {} to readonly failed.", (Object)instance.getId());
            }
        });
    }

    private boolean isNotFinishedProcessInstance(ProcessInstanceDto instance) {
        return ProcessStatus.RUNNING.equals((Object)instance.getStatus()) || ProcessStatus.PAUSE.equals((Object)instance.getStatus());
    }

    private void setProcessInstanceReadOnly(String instanceId) {
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().processInstanceId(instanceId).operationType("Create").singleResult();
        if (userOperationLogEntry != null) {
            this.historyService.setAnnotationForOperationLogById(userOperationLogEntry.getOperationId(), "readonly");
        }
    }

    private boolean isProcessInstanceReadOnly(String instanceId) {
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().processInstanceId(instanceId).operationType("Create").singleResult();
        String annotation = userOperationLogEntry == null ? "" : userOperationLogEntry.getAnnotation();
        return "readonly".equals(annotation);
    }

    @Override
    public void startProcessInstance(String instanceId) {
        Task task = (Task)this.processEngine.getTaskService().createTaskQuery().processInstanceId(instanceId).active().singleResult();
        this.processEngine.getTaskService().complete(task.getId());
    }

    @Override
    public void setProcessInstanceContext(String instanceId, ProcessConfig processConfig) {
        CryptUtil.encryptUpdateBusiness(this.cryptService, processConfig);
        this.runtimeService.setVariable(instanceId, "context", (Object)processConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessInstanceDto> queryAllProcessInstance(String processDefinitionKey) {
        List<HistoricProcessInstance> hisProcessInstance;
        Object object = VARIABLE_TASK_LOCK;
        synchronized (object) {
            hisProcessInstance = this.queryHistoricProcessInstances(processDefinitionKey);
        }
        return hisProcessInstance.stream().map(instance -> {
            try {
                return this.buildProcessInstance((HistoricProcessInstance)instance);
            }
            catch (ProcessEncryptException | ActiveDelegateException e) {
                log.error("query process install failed.", e);
                return null;
            }
        }).filter(Objects::nonNull).filter(this::checkProcessConfigBusinessValid).collect(Collectors.toList());
    }

    boolean checkProcessConfigBusinessValid(ProcessInstanceDto processInstanceDto) {
        return Optional.ofNullable(processInstanceDto.getProcessConfig()).filter(ProcessConfig.class::isInstance).map(ProcessConfig.class::cast).map(ProcessConfig::getBusiness).filter(MapUtils::isNotEmpty).isPresent();
    }

    private List<HistoricProcessInstance> queryHistoricProcessInstances(String processDefinitionKey) {
        if (StringUtils.isEmpty((CharSequence)processDefinitionKey)) {
            return ((HistoricProcessInstanceQuery)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().orderByProcessInstanceStartTime().desc()).list();
        }
        return ((HistoricProcessInstanceQuery)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processDefinitionKey(processDefinitionKey).orderByProcessInstanceStartTime().desc()).list();
    }

    @Override
    public boolean canStartProcessInstance(String processInstanceId) {
        return this.queryAllProcessInstance(null).stream().filter(instanceDto -> !BpmConstants.ALLOW_PARALLEL_PROCESS_DEFINITION_KEYS.contains(instanceDto.getType())).noneMatch(instanceDto -> instanceDto.getStatus().equals((Object)ProcessStatus.RUNNING));
    }

    @Override
    public boolean canStartProcessInstanceWithNoParallel() {
        return this.queryAllProcessInstance(null).stream().noneMatch(instanceDto -> instanceDto.getStatus().equals((Object)ProcessStatus.RUNNING));
    }

    @Override
    public ProcessInstanceDto queryProcessInstance(String processInstanceId) {
        HistoricProcessInstance hisProcessInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (hisProcessInstance == null) {
            log.warn("process instance id: {} not exist.", (Object)processInstanceId);
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        return this.buildProcessInstance(hisProcessInstance);
    }

    private ProcessInstanceDto buildProcessInstance(HistoricProcessInstance hisProcessInstance) {
        Map<String, Object> variableInstances = this.queryProcessInstanceDynamicInfo(hisProcessInstance.getId());
        boolean readOnly = this.isProcessInstanceReadOnly(hisProcessInstance.getId());
        ProcessInstanceDto processInstanceDto = ProcessInstanceDto.from(hisProcessInstance).updateVariable(variableInstances).updateReadOnly(readOnly).updateProgress(this.calculateProgress(hisProcessInstance.getId()));
        ProcessStatus processStatus = Optional.ofNullable(variableInstances.get("pause")).filter(Boolean.class::isInstance).map(Boolean.class::cast).orElse(false) != false ? ProcessStatus.PAUSE : ProcessStatus.FAILED;
        this.queryAndSetIncidentErrMsg(processInstanceDto, processStatus);
        if (processInstanceDto.getProcessConfig() instanceof ProcessConfig) {
            ProcessConfig processConfig = (ProcessConfig)processInstanceDto.getProcessConfig();
            if (processConfig.getBusiness() == null) {
                processConfig.setBusiness(Collections.emptyMap());
            } else {
                CryptUtil.decryptUpdateBusiness(this.cryptService, processConfig);
            }
        }
        return processInstanceDto;
    }

    private void queryAndSetIncidentErrMsg(ProcessInstanceDto processInstanceDto, ProcessStatus incidentStatus) {
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstanceDto.getId()).list();
        boolean isRunning = this.queryProcessStructure(processInstanceDto.getId()).stream().anyMatch(active -> active.getStatus() == ProcessStatus.RUNNING);
        String errMsg = incidents.stream().map(Incident::getIncidentMessage).collect(Collectors.joining(System.lineSeparator()));
        if (!isRunning && !StringUtils.isEmpty((CharSequence)errMsg)) {
            if (processInstanceDto.getStatus() == ProcessStatus.RUNNING) {
                processInstanceDto.setStatus(incidentStatus);
            }
            processInstanceDto.setErrMsg(errMsg);
        }
    }

    @Override
    public int calculateProgress(String processInstanceId) {
        List<ActivityImpl> activities = this.queryActivityStaticInfo(processInstanceId);
        Map<String, Object> processVariables = this.queryProcessInstanceDynamicInfo(processInstanceId);
        List allActivities = activities.stream().map(this::flatActivitiesFromTree).flatMap(Collection::stream).collect(Collectors.toList());
        List serviceTaskActivities = allActivities.stream().filter(activity -> BpmnExtension.isServiceTaskActivity(activity.getProperties())).filter(activity -> this.isDisplayActivity(activity.getActivityId(), processVariables)).collect(Collectors.toList());
        int totalWeight = serviceTaskActivities.stream().mapToInt(activity -> BpmnExtension.getEstimatedDuration(activity.getProperties())).sum();
        List historicActivityInstances = this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        double executedWeight = serviceTaskActivities.stream().mapToDouble(activity -> this.calculateExecutedActivityWeight((ActivityImpl)activity, historicActivityInstances)).sum();
        return (int)executedWeight * 100 / totalWeight;
    }

    private List<ActivityImpl> flatActivitiesFromTree(ActivityImpl activity) {
        ArrayList<ActivityImpl> activities = new ArrayList<ActivityImpl>();
        this.flatActivity(activity, activities);
        return activities;
    }

    private void flatActivity(ActivityImpl activity, List<ActivityImpl> activities) {
        activities.add(activity);
        if (!CollectionUtils.isEmpty((Collection)activity.getActivities())) {
            activity.getActivities().forEach(item -> this.flatActivity((ActivityImpl)item, activities));
        }
    }

    private double calculateExecutedActivityWeight(ActivityImpl activity, List<HistoricActivityInstance> historicActivityInstances) {
        int weight = BpmnExtension.getEstimatedDuration(activity.getProperties());
        List currentHisInstances = historicActivityInstances.stream().filter(hisInstance -> Objects.equals(hisInstance.getActivityId(), activity.getActivityId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentHisInstances)) {
            return 0.0;
        }
        long executedCount = currentHisInstances.stream().filter(hisInstance -> hisInstance.getEndTime() != null).count();
        return (double)((long)weight * executedCount) * 1.0 / (double)currentHisInstances.size();
    }

    private String getProcessDefinitionId(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance != null) {
            return processInstance.getProcessDefinitionId();
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.processEngine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            log.warn("process instance id: {} not exist.", (Object)processInstanceId);
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        return historicProcessInstance.getProcessDefinitionId();
    }

    private List<ActivityImpl> queryActivityStaticInfo(String processInstanceId) {
        String processDefinitionId = this.getProcessDefinitionId(processInstanceId);
        ProcessDefinitionEntity processDefineIns = (ProcessDefinitionEntity)this.processEngine.getRepositoryService().getProcessDefinition(processDefinitionId);
        return processDefineIns.getActivities().stream().filter(activity -> BpmnExtension.isDisplayActivity(activity.getProperties())).collect(Collectors.toList());
    }

    @Override
    public ProcessActivity querySingleActivityByInstanceId(String activityInstanceId) {
        HistoricActivityInstance activityInstance = (HistoricActivityInstance)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().activityInstanceId(activityInstanceId).singleResult();
        if (activityInstance == null) {
            log.warn("activity: {} not exist.", (Object)activityInstanceId);
            throw new ActiveDelegateException(-1, ResourceUtils.getString((String)"request.param.invalid"), "");
        }
        ProcessActivity activity = ProcessActivity.fromHistoryActivity((HistoricActivityInstanceEntity)activityInstance).updateVariables(this.queryProcessActivityDynamicInfo(activityInstance.getId()));
        List<ProcessActivity> childActivities = this.queryChildActivityByInstanceId(activityInstance.getProcessInstanceId(), activityInstanceId);
        if (childActivities != null && !childActivities.isEmpty()) {
            activity.setChildren(childActivities);
            activity.setStatus(this.mergeStatus(childActivities));
        }
        return activity;
    }

    @Override
    public void retryProcessActivity(ProcessActivity activity) {
        this.retryProcessActivity(activity, null);
    }

    @Override
    public void retryProcessActivity(ProcessActivity activity, OperateCmd operateCmd) {
        if (activity.getChildren() == null || activity.getChildren().isEmpty()) {
            this.retryActivity(activity, operateCmd);
        } else {
            activity.getChildren().stream().filter(this::checkActivityCanBeRetry).findFirst().ifPresent(childActivity -> this.retryActivity((ProcessActivity)childActivity, operateCmd));
        }
    }

    private boolean checkActivityCanBeRetry(ProcessActivity item) {
        return ProcessStatus.FAILED.equals((Object)item.getStatus()) || ProcessStatus.PAUSE.equals((Object)item.getStatus());
    }

    private void retryActivity(ProcessActivity activity, OperateCmd operateCmd) {
        log.info("begin to retry activity: {}", (Object)activity.getActivityInstanceId());
        HistoricActivityInstance activityInstance = (HistoricActivityInstance)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().activityInstanceId(activity.getActivityInstanceId()).singleResult();
        if (activityInstance == null) {
            log.warn("retry activity instance is null.");
            return;
        }
        org.camunda.bpm.engine.externaltask.ExternalTask task = (org.camunda.bpm.engine.externaltask.ExternalTask)this.externalTaskService.createExternalTaskQuery().activityId(activityInstance.getActivityId()).executionId(activityInstance.getExecutionId()).singleResult();
        if (operateCmd == null) {
            this.runtimeService.setVariable(activityInstance.getExecutionId(), activity.getActivityInstanceId(), (Object)"retry");
        }
        this.sendTaskMessageEvent(task.getExecutionId(), operateCmd);
        this.externalTaskService.setRetries(task.getId(), 1);
    }

    private void sendTaskMessageEvent(String executionId, OperateCmd operateCmd) {
        if (operateCmd != null) {
            log.info("begin to send message: {}", (Object)operateCmd);
            HashMap<String, OperateCmd> variables = new HashMap<String, OperateCmd>();
            variables.put("operateCmd", operateCmd);
            this.runtimeService.messageEventReceived(operateCmd.getCmd(), executionId, variables);
        }
    }

    private List<ProcessActivity> queryActivityById(String processInstanceId, String activityId) {
        List historicActivityInstances = this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).activityId(activityId).list();
        return this.transProcessActivity(historicActivityInstances);
    }

    public List<ProcessActivity> queryChildActivityByInstanceId(String processInstanceId, String activityInstanceId) {
        List<HistoricActivityInstance> activityInstances = ((HistoricActivityInstanceQuery)this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderPartiallyByOccurrence().asc()).list().stream().filter(activityInstance -> activityInstance.getParentActivityInstanceId().equals(activityInstanceId)).collect(Collectors.toList());
        return this.transProcessActivity(activityInstances);
    }

    public ProcessActivity querySingleActivityDetail(ProcessActivityQueryDto condition) {
        if (condition.getActivityId() != null) {
            return this.queryActivityById(condition.getInstanceId(), condition.getActivityId()).get(0);
        }
        return this.querySingleActivityByInstanceId(condition.getActivityInstanceId());
    }

    public List<ProcessActivity> queryProcessStructure(String processInstanceId) {
        List<ActivityImpl> activities = this.queryActivityStaticInfo(processInstanceId);
        List<ProcessActivity> processActivities = activities.stream().map(ProcessActivity::fromRepositoryActivity).collect(Collectors.toList());
        List<ProcessActivity> hisActivities = this.getExecutedProcessActivities(processInstanceId);
        processActivities.forEach(activity -> this.processOneMultiInstance((ProcessActivity)activity, hisActivities));
        processActivities.forEach(activity -> this.updateOneActivityInstance((ProcessActivity)activity, hisActivities));
        processActivities.forEach(this::refreshProcessStatus);
        return this.filterActivityByVariables(processInstanceId, processActivities);
    }

    private void refreshProcessStatus(ProcessActivity activity) {
        if (activity.getChildren() == null || activity.getChildren().isEmpty()) {
            return;
        }
        activity.getChildren().forEach(this::refreshProcessStatus);
        activity.setStatus(this.mergeStatus(activity.getChildren()));
    }

    private ProcessStatus mergeStatus(List<ProcessActivity> childActivities) {
        List allStatus = childActivities.stream().map(ProcessActivity::getStatus).collect(Collectors.toList());
        if (allStatus.contains((Object)ProcessStatus.RUNNING)) {
            return ProcessStatus.RUNNING;
        }
        if (allStatus.contains((Object)ProcessStatus.FAILED)) {
            return ProcessStatus.FAILED;
        }
        if (allStatus.contains((Object)ProcessStatus.PAUSE)) {
            return ProcessStatus.PAUSE;
        }
        if (allStatus.contains((Object)ProcessStatus.NO_START)) {
            return ProcessStatus.NO_START;
        }
        return ProcessStatus.SUCCEED;
    }

    private void processOneMultiInstance(ProcessActivity activity, List<ProcessActivity> historyInstances) {
        if (activity.getChildren() == null || activity.getChildren().isEmpty()) {
            return;
        }
        activity.getChildren().forEach(item -> this.processOneMultiInstance((ProcessActivity)item, historyInstances));
        if (!activity.getId().contains(MULTI_INSTANCE_BODY)) {
            return;
        }
        List<ProcessActivity> activities = historyInstances.stream().filter(instance -> instance.getId().equals(activity.getId().replace(MULTI_INSTANCE_BODY, ""))).peek(item -> item.setChildren(activity.getChildren().get(0).getChildren())).collect(Collectors.toList());
        activity.setChildren(activities);
    }

    private void updateOneActivityInstance(ProcessActivity activity, List<ProcessActivity> historyInstances) {
        if (activity.getChildren() != null && !activity.getChildren().isEmpty()) {
            activity.getChildren().forEach(item -> this.updateOneActivityInstance((ProcessActivity)item, historyInstances));
        }
        Optional<ProcessActivity> destActivity = Optional.empty();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{activity.getActivityInstanceId()})) {
            destActivity = historyInstances.stream().filter(historyInstance -> historyInstance.getActivityInstanceId().equals(activity.getActivityInstanceId())).findFirst();
        }
        if (!destActivity.isPresent()) {
            destActivity = historyInstances.stream().filter(historyInstance -> historyInstance.getId().equals(activity.getId())).findFirst();
        }
        destActivity.ifPresent(item -> this.updateActivityData(activity, (ProcessActivity)item));
    }

    private void updateActivityData(ProcessActivity activity, ProcessActivity destActivity) {
        activity.setActivityInstanceId(destActivity.getActivityInstanceId());
        activity.setStatus(destActivity.getStatus());
        activity.setBusiness(destActivity.getBusiness());
    }

    private List<ProcessActivity> filterActivityByVariables(String processInstanceId, List<ProcessActivity> processActivities) {
        Map<String, Object> processVariables = this.queryProcessInstanceDynamicInfo(processInstanceId);
        return processActivities.stream().map(activity -> this.filterOneActivity((ProcessActivity)activity, processVariables)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ProcessActivity> filterOneActivity(ProcessActivity activity, Map<String, Object> processVariables) {
        if (!this.isDisplayActivity(activity, processVariables)) {
            return Optional.empty();
        }
        if (activity.getChildren() != null) {
            activity.setChildren(activity.getChildren().stream().map(item -> this.filterOneActivity((ProcessActivity)item, processVariables)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
        }
        return Optional.of(activity);
    }

    private boolean isDisplayActivity(ProcessActivity activity, Map<String, Object> processVariables) {
        if (activity.getChildren() == null) {
            return false;
        }
        Map conditionObj = (Map)ObjectMapperUtils.transKey(processVariables, Map.class, (String)"conditionVar", null);
        return (Boolean)ObjectMapperUtils.transKey((Map)conditionObj, Boolean.class, (String)activity.getId(), (Object)true);
    }

    private boolean isDisplayActivity(String activityId, Map<String, Object> processVariables) {
        Map conditionObj = (Map)ObjectMapperUtils.transKey(processVariables, Map.class, (String)"conditionVar", null);
        return (Boolean)ObjectMapperUtils.transKey((Map)conditionObj, Boolean.class, (String)activityId, (Object)true);
    }

    private Optional<ActivityImpl> findTargetActivity(String processInstanceId, String targetId) {
        List<ActivityImpl> allActivities = this.queryActivityStaticInfo(processInstanceId);
        for (ActivityImpl activity : allActivities) {
            Optional<ActivityImpl> target = this.findTarget(activity, targetId);
            if (!target.isPresent()) continue;
            return target;
        }
        return Optional.empty();
    }

    private Optional<ActivityImpl> findTarget(ActivityImpl activity, String targetId) {
        if (targetId.equals(activity.getId())) {
            return Optional.of(activity);
        }
        if (activity.getActivities() != null) {
            for (ActivityImpl item : activity.getActivities()) {
                Optional<ActivityImpl> target = this.findTarget(item, targetId);
                if (!target.isPresent()) continue;
                return target;
            }
        }
        return Optional.empty();
    }

    public boolean checkActivityExecutedCondition(ExternalTask task) {
        Optional<ActivityImpl> activityImpl = this.findTargetActivity(task.getProcessInstanceId(), task.getActivityId());
        if (!activityImpl.isPresent()) {
            return true;
        }
        ProcessActivity activity = ProcessActivity.fromRepositoryActivity(activityImpl.get());
        if (activity.getExtensions() == null) {
            return true;
        }
        String condition = (String)activity.getExtensions().getOrDefault("condition", "");
        if (StringUtils.isEmpty((CharSequence)condition)) {
            return true;
        }
        Map activityVariables = task.getAllVariables();
        String activityConditionValue = activityVariables.getOrDefault(condition, "");
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{activityConditionValue})) {
            return activityConditionValue.equals("true");
        }
        Map<String, Object> processVariables = this.queryProcessInstanceDynamicInfo(task.getProcessInstanceId());
        String conditionValue = (String)processVariables.getOrDefault(condition, "");
        return conditionValue.equals("true");
    }

    @Override
    public List<ProcessActivity> queryActivityDetail(ProcessActivityQueryDto condition) {
        if (condition.getParentId() != null) {
            return this.queryChildActivityByInstanceId(condition.getInstanceId(), condition.getParentId());
        }
        if (condition.getActivityId() != null) {
            return this.queryActivityById(condition.getInstanceId(), condition.getActivityId());
        }
        return this.queryProcessStructure(condition.getInstanceId());
    }

    private List<ProcessActivity> getExecutedProcessActivities(String processInstanceId) {
        List historicActivityInstances = this.processEngine.getHistoryService().createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        return this.transProcessActivity(historicActivityInstances);
    }

    private List<ProcessActivity> transProcessActivity(List<HistoricActivityInstance> historicProcessInstances) {
        return historicProcessInstances.stream().filter(item -> BpmnExtension.isDisplayActivity(item.getActivityType())).map(item -> ProcessActivity.fromHistoryActivity((HistoricActivityInstanceEntity)item)).peek(item -> item.updateVariables(this.queryProcessActivityDynamicInfo(item.getActivityInstanceId()))).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> queryProcessInstanceDynamicInfo(String processInstanceId) {
        List historicVariableInstances = this.processEngine.getHistoryService().createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).list();
        return this.transVariables(historicVariableInstances);
    }

    private Map<String, Object> queryProcessActivityDynamicInfo(String activityId) {
        List historicVariableInstances = this.processEngine.getHistoryService().createHistoricVariableInstanceQuery().activityInstanceIdIn(new String[]{activityId}).list();
        return this.transVariables(historicVariableInstances);
    }

    Map<String, Object> transVariables(List<HistoricVariableInstance> variables) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        variables.forEach(variable -> data.put(variable.getName(), variable.getValue()));
        boolean isPause = variables.stream().filter(variable -> "pause".equals(variable.getName())).anyMatch(variable -> (Boolean)variable.getValue());
        if (isPause) {
            data.put("pause", true);
        }
        return data;
    }

    public CamundaEngineServiceImpl(ProcessEngine processEngine, RuntimeService runtimeService, HistoryService historyService, ExternalTaskService externalTaskService, BpmCryptService cryptService) {
        this.processEngine = processEngine;
        this.runtimeService = runtimeService;
        this.historyService = historyService;
        this.externalTaskService = externalTaskService;
        this.cryptService = cryptService;
    }
}

