/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.rest;

import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.BpmEngineService;
import com.huawei.yinglong.bpm.BpmPropertyConfig;
import com.huawei.yinglong.bpm.BpmValidateService;
import com.huawei.yinglong.bpm.dto.OperateCmd;
import com.huawei.yinglong.bpm.dto.ProcessActivity;
import com.huawei.yinglong.bpm.dto.ProcessActivityQueryDto;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.dto.ProcessInstanceQueryDto;
import com.huawei.yinglong.bpm.dto.ProcessStatus;
import com.huawei.yinglong.bpm.exception.ActiveDelegateException;
import com.huawei.yinglong.bpm.util.CryptUtil;
import com.huawei.yinglong.bpm.util.ResponseUtil;
import com.huawei.yinglong.bpm.util.ToolLifecycleMessageReportUtil;
import com.huawei.yinglong.bpm.util.ValidateUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.smartkit.base.util.ResourceUtils;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine"})
public class ProcessOrchestrationRestServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ProcessOrchestrationRestServiceImpl.class);
    private final RuntimeService runtimeService;
    private final TaskService taskService;
    private final RepositoryService repositoryService;
    private final BpmEngineService bpmEngineService;
    private final BpmContextService bpmContextService;
    private final BpmCryptService bpmCryptService;
    private final BpmValidateService bpmValidateService;
    private final Pattern processNamePattern = Pattern.compile("^([0-9A-Za-z\\u4e00-\\u9fa5])([0-9A-Za-z\\u4e00-\\u9fa5_\\-\\s]{0,126})([0-9A-Za-z\\u4e00-\\u9fa5])$");
    private BpmPropertyConfig bpmPropertyConfig;

    private static String getResponseFailedDelimiter() {
        return SystemEnvUtil.getLanguage() == Locale.SIMPLIFIED_CHINESE ? "\uff1b " : "; ";
    }

    @PostMapping(value={"/process-instance"})
    public Response<?> createProcessInstance(@RequestBody ProcessConfig processConfig) {
        List<String> validateTips;
        log.info("begin to create process instance");
        if (!this.checkProcessInstanceNameValidity(processConfig.getName())) {
            log.error("The task name of the instance is invalid");
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"create.task.failed.for.task.name.invalid"), "");
        }
        if (processConfig.getBusiness() == null) {
            processConfig.setBusiness(Collections.emptyMap());
        }
        if (CollectionUtils.isNotEmpty(validateTips = ValidateUtil.validateProcessConfig(this.bpmValidateService, processConfig))) {
            return ResponseUtil.failed(String.join((CharSequence)ProcessOrchestrationRestServiceImpl.getResponseFailedDelimiter(), validateTips), "");
        }
        CryptUtil.encryptUpdateBusiness(this.bpmCryptService, processConfig);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("context", processConfig);
        variables.put("status", (Object)ProcessStatus.NO_START);
        if (!this.checkProcessInstanceSpecification(processConfig.getType())) {
            log.error("create task size overload max size({}).", (Object)this.bpmPropertyConfig.getMaxTaskNum());
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"create.task.failed.for.has.beyond.specification"), "");
        }
        if (this.checkProcessNameConflict(processConfig.getType(), processConfig.getName())) {
            log.info("create instance failed for process name conflict");
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"create.task.failed.for.has.same.name"), "");
        }
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processConfig.getType(), processConfig.getName(), variables);
        return ResponseUtil.success(processInstance.getId());
    }

    private boolean checkProcessInstanceNameValidity(String name) {
        return this.processNamePattern.matcher(name).find();
    }

    private boolean checkProcessInstanceSpecification(String type) {
        List<ProcessInstanceDto> processInstances = this.bpmEngineService.queryAllProcessInstance(type);
        return processInstances.size() < this.bpmPropertyConfig.getMaxTaskNum();
    }

    private boolean checkProcessNameConflict(String type, String name) {
        List<ProcessInstanceDto> processInstances = this.bpmEngineService.queryAllProcessInstance(type);
        return processInstances.stream().anyMatch(processInstance -> Objects.equals(processInstance.getName(), name));
    }

    @GetMapping(value={"/process_definition/{processId}"})
    public Response<?> queryProcessDefinition(@PathVariable(value="processId") String processId) {
        ProcessDefinition definitions = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processId).singleResult();
        return ResponseUtil.success(definitions);
    }

    @PutMapping(value={"/process-instance/{id}"})
    public Response<?> updateProcessInstance(@PathVariable(value="id") String instanceId, @RequestBody ProcessConfig processConfig) {
        List<String> validateTips;
        log.info("update process instance. id={}", (Object)instanceId);
        if (processConfig.getBusiness() == null) {
            processConfig.setBusiness(Collections.emptyMap());
        }
        if (CollectionUtils.isNotEmpty(validateTips = ValidateUtil.validateProcessConfig(this.bpmValidateService, processConfig))) {
            return ResponseUtil.failed(String.join((CharSequence)ProcessOrchestrationRestServiceImpl.getResponseFailedDelimiter(), validateTips), "");
        }
        try {
            this.bpmEngineService.setProcessInstanceContext(instanceId, processConfig);
            return ResponseUtil.success();
        }
        catch (Exception e) {
            log.error("update process {} info failed : {}.", new Object[]{instanceId, e.getMessage(), e});
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"request.param.invalid"), "");
        }
    }

    @PostMapping(value={"/process-instance/start/{id}"})
    public Response<?> startProcessInstance(@PathVariable(value="id") String instanceId, @RequestBody ProcessConfig processConfig) {
        try {
            List<String> validateTips;
            log.info("start process instance. id={}", (Object)instanceId);
            if (!this.bpmEngineService.canStartProcessInstanceWithNoParallel()) {
                return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"start.failed.for.has.running.task"), "");
            }
            if (processConfig.getBusiness() == null) {
                processConfig.setBusiness(Collections.emptyMap());
            }
            if (CollectionUtils.isNotEmpty(validateTips = ValidateUtil.validateProcessConfig(this.bpmValidateService, processConfig))) {
                return ResponseUtil.failed(String.join((CharSequence)ProcessOrchestrationRestServiceImpl.getResponseFailedDelimiter(), validateTips), "");
            }
            if (processConfig.getType() != null) {
                CryptUtil.encryptUpdateBusiness(this.bpmCryptService, processConfig);
                this.runtimeService.setVariable(instanceId, "context", (Object)processConfig);
            }
            ToolLifecycleMessageReportUtil.reportStmMessage(this.bpmEngineService.queryProcessInstance(instanceId));
            this.runtimeService.setVariable(instanceId, "status", (Object)ProcessStatus.RUNNING);
            this.runtimeService.setVariable(instanceId, "startTime", (Object)System.currentTimeMillis());
            Task task = (Task)this.taskService.createTaskQuery().processInstanceId(instanceId).active().singleResult();
            this.taskService.complete(task.getId());
            return ResponseUtil.success();
        }
        catch (Exception e) {
            log.error("start process instance {} failed.", (Object)instanceId, (Object)e);
            if (e instanceof ActiveDelegateException) {
                ActiveDelegateException activeException = (ActiveDelegateException)e;
                this.bpmContextService.setStatus(instanceId, ProcessStatus.FAILED);
                log.error("current exception is ActiveDelegateException.");
                return ResponseUtil.failed(activeException.getDescription(), activeException.getSuggestion());
            }
            Throwable cause = e.getCause();
            if (cause instanceof ActiveDelegateException) {
                ActiveDelegateException activeException = (ActiveDelegateException)cause;
                this.bpmContextService.setStatus(instanceId, ProcessStatus.FAILED);
                log.error("current cause exception is ActiveDelegateException.");
                return ResponseUtil.failed(activeException.getDescription(), activeException.getSuggestion());
            }
            this.bpmContextService.setStatus(instanceId, ProcessStatus.FAILED);
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"start.failed"), "");
        }
    }

    @PostMapping(value={"/process-instance/{id}/message"})
    public Response<String> sendMessage(@PathVariable(value="id") String instanceId, @RequestBody OperateCmd operateCmd) {
        try {
            ProcessInstanceDto processInstanceDto = this.bpmEngineService.queryProcessInstance(instanceId);
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName(operateCmd.getCmd()).processInstanceId(processInstanceDto.getId()).singleResult();
            if (operateCmd.getExtras() != null) {
                log.info("send message {} has extras, size : {}.", (Object)operateCmd.getCmd(), (Object)operateCmd.getExtras().size());
                this.runtimeService.messageEventReceived(operateCmd.getCmd(), execution.getId(), operateCmd.getExtras());
            } else {
                log.info("send message {} has no extras, execution={}.", (Object)operateCmd.getCmd(), (Object)execution);
                if (execution == null) {
                    return ResponseUtil.success("");
                }
                log.info("send message {}, execution id : {}.", (Object)operateCmd.getCmd(), (Object)execution.getId());
                this.runtimeService.messageEventReceived(operateCmd.getCmd(), execution.getId());
            }
        }
        catch (Exception e) {
            log.error("send message {} failed.", (Object)operateCmd.getCmd(), (Object)e);
            return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"start.failed"), "");
        }
        return ResponseUtil.success("");
    }

    @GetMapping(value={"/process-instance"})
    public Response<?> queryAllProcessInstance(ProcessInstanceQueryDto condition) {
        try {
            return ResponseUtil.success(this.bpmEngineService.queryAllProcessInstance(condition.getType()));
        }
        catch (ActiveDelegateException e) {
            log.error("query all process instance error.", (Throwable)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @GetMapping(value={"/process-instance/{id}"})
    public Response<?> queryProcessInstance(@PathVariable(value="id") String instanceId) {
        try {
            return ResponseUtil.success(this.bpmEngineService.queryProcessInstance(instanceId));
        }
        catch (ActiveDelegateException e) {
            log.error("query process instance id error. instance id={}", (Object)instanceId, (Object)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @GetMapping(value={"/process-activity"})
    public Response<?> queryProcessActivities(ProcessActivityQueryDto condition) {
        try {
            List<ProcessActivity> activities = this.bpmEngineService.queryActivityDetail(condition);
            return ResponseUtil.success(activities);
        }
        catch (ActiveDelegateException e) {
            log.error("query process activities error. instance id={}", (Object)condition.getInstanceId(), (Object)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @GetMapping(value={"/process-activity/{activityInstanceId}"})
    public Response<?> querySingleActivity(@PathVariable String activityInstanceId) {
        try {
            ProcessActivity activities = this.bpmEngineService.querySingleActivityByInstanceId(activityInstanceId);
            return ResponseUtil.success(activities);
        }
        catch (ActiveDelegateException e) {
            log.error("query activity instance id error. id={}", (Object)activityInstanceId, (Object)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @PostMapping(value={"/process-instance/retry/activity/{activityInstanceId}"})
    public Response<?> retryProcessActivity(@PathVariable String activityInstanceId) {
        try {
            log.info("retry activity. activity instance id={}", (Object)activityInstanceId);
            return this.retryProcessActivity(activityInstanceId, null);
        }
        catch (ActiveDelegateException e) {
            log.error("retry process activity error. id={}", (Object)activityInstanceId, (Object)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @PostMapping(value={"/process-instance/operate/activity/{activityInstanceId}"})
    public Response<?> retryProcessActivity(@PathVariable String activityInstanceId, @RequestBody OperateCmd operateCmd) {
        try {
            log.info("operate activity. activity instance id={}, operate cmd={}", (Object)activityInstanceId, (Object)operateCmd);
            ProcessActivity activity = this.bpmEngineService.querySingleActivityByInstanceId(activityInstanceId);
            if (activity == null) {
                log.info("activityInstanceId is invalid, retry failed.");
                return ResponseUtil.failed(ResourceUtils.getString((String)"request.param.invalid"), "");
            }
            if (!this.bpmEngineService.canStartProcessInstance(activity.getProcessInstanceId())) {
                log.error("can not start process instance, id:{}, cmd:{}.", (Object)activityInstanceId, (Object)operateCmd.getCmd());
                return ResponseUtil.failed(ResourceUtils.getString((String)"retry.failed.for.has.running.task"), "");
            }
            this.bpmEngineService.retryProcessActivity(activity, operateCmd);
            return ResponseUtil.success();
        }
        catch (ActiveDelegateException e) {
            log.error("retry process activity error. id={}, cmd={}.", new Object[]{activityInstanceId, operateCmd.getCmd(), e});
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @PostMapping(value={"/process-instance/ignore/{id}/activity/{activityId}"})
    public Response<?> ignoreProcessActivity(@PathVariable(value="id") String instanceId, @PathVariable(value="activityId") String activityId) {
        try {
            ((ProcessInstanceModificationInstantiationBuilder)((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(instanceId).cancelAllForActivity(activityId).startBeforeActivity(activityId)).setVariableLocal("operateType", (Object)"ignore")).execute();
            return ResponseUtil.success();
        }
        catch (ActiveDelegateException e) {
            log.error("ignore process activity error. instanceId={}, activity id={}.", new Object[]{instanceId, activityId, e});
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    @DeleteMapping(value={"/process-instance"})
    public Response<?> deleteProcessInstance(@RequestParam String id) {
        try {
            log.info("delete process instance. id={}", (Object)id);
            List<String> deleteIds = Arrays.asList(id.split(","));
            if (this.checkExistRunningProcess(deleteIds)) {
                log.error("delete process instance failed, has exist running process.");
                return ResponseUtil.failed(ResourceUtils.getStringFromErrorMsg((String)"delete.failed.for.has.running.task"), "");
            }
            this.bpmEngineService.deleteProcessInstance(deleteIds);
            return ResponseUtil.success();
        }
        catch (ActiveDelegateException e) {
            log.error("delete process instance error. id={}.", (Object)id, (Object)e);
            return ResponseUtil.failed(e.getDescription(), e.getSuggestion());
        }
    }

    private boolean checkExistRunningProcess(List<String> deleteIds) {
        return deleteIds.stream().map(instanceId -> this.bpmEngineService.queryProcessInstance((String)instanceId).getStatus()).anyMatch(status -> status.equals((Object)ProcessStatus.RUNNING));
    }

    public ProcessOrchestrationRestServiceImpl(RuntimeService runtimeService, TaskService taskService, RepositoryService repositoryService, BpmEngineService bpmEngineService, BpmContextService bpmContextService, BpmCryptService bpmCryptService, BpmValidateService bpmValidateService, BpmPropertyConfig bpmPropertyConfig) {
        this.runtimeService = runtimeService;
        this.taskService = taskService;
        this.repositoryService = repositoryService;
        this.bpmEngineService = bpmEngineService;
        this.bpmContextService = bpmContextService;
        this.bpmCryptService = bpmCryptService;
        this.bpmValidateService = bpmValidateService;
        this.bpmPropertyConfig = bpmPropertyConfig;
    }
}

