/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.util;

import com.huawei.yinglong.bpm.BpmCryptService;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptUtil {
    private static final Logger log = LoggerFactory.getLogger(CryptUtil.class);

    public static void encryptUpdateBusiness(BpmCryptService cryptService, ProcessConfig config) {
        CryptUtil.encryptBusiness(cryptService, config, true);
    }

    public static Map<String, Object> encryptDirectBusiness(BpmCryptService cryptService, ProcessConfig config) {
        return CryptUtil.encryptBusiness(cryptService, config, false);
    }

    private static Map<String, Object> encryptBusiness(BpmCryptService cryptService, ProcessConfig config, boolean isUpdate) {
        Map<String, Object> tmpBusinessMap;
        if (CryptUtil.checkParamIsSkipCrypt(cryptService, config)) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = tmpBusinessMap = isUpdate ? config.getBusiness() : CryptUtil.deepCopyMaps(config.getBusiness());
        if (cryptService.encryptProcessBusiness(tmpBusinessMap)) {
            return tmpBusinessMap;
        }
        log.warn("encrypt business failed, type:{}.", (Object)config.getType());
        return Collections.emptyMap();
    }

    public static void decryptUpdateBusiness(BpmCryptService cryptService, ProcessConfig config) {
        CryptUtil.decryptBusiness(cryptService, config, true);
    }

    public static Map<String, Object> decryptDirectBusiness(BpmCryptService cryptService, ProcessConfig config) {
        return CryptUtil.decryptBusiness(cryptService, config, false);
    }

    private static Map<String, Object> decryptBusiness(BpmCryptService cryptService, ProcessConfig config, boolean isUpdate) {
        Map<String, Object> tmpBusinessMap;
        if (CryptUtil.checkParamIsSkipCrypt(cryptService, config)) {
            return Collections.emptyMap();
        }
        Map<String, Object> map = tmpBusinessMap = isUpdate ? config.getBusiness() : CryptUtil.deepCopyMaps(config.getBusiness());
        if (cryptService.decryptProcessBusiness(tmpBusinessMap)) {
            return tmpBusinessMap;
        }
        log.warn("decrypt business failed, type:{}.", (Object)config.getType());
        return Collections.emptyMap();
    }

    private static boolean checkParamIsSkipCrypt(BpmCryptService cryptService, ProcessConfig config) {
        if (cryptService == null || config.getBusiness() == null || config.getBusiness().isEmpty()) {
            log.warn("no crypt service or no business, service:{}.", (Object)cryptService);
            return true;
        }
        return false;
    }

    public static void cryptSpecialField(Map<String, Object> business, String field, UnaryOperator<String> cryptor) {
        if (business == null || business.isEmpty() || StringUtils.isEmpty((CharSequence)field)) {
            log.warn("not need to crypt key:{}.", (Object)field);
            return;
        }
        String[] fields = field.split("#");
        Map handleMaps = business;
        for (int idx = 0; idx < fields.length; ++idx) {
            Object mapValue = handleMaps.get(fields[idx]);
            if (mapValue instanceof Map) {
                handleMaps = (Map)mapValue;
                continue;
            }
            if (mapValue instanceof List) {
                String remainField = Arrays.stream(fields).skip((long)idx + 1L).collect(Collectors.joining("#"));
                CryptUtil.cryptListFields((List)mapValue, remainField, cryptor);
                break;
            }
            if (idx != fields.length - 1 || !(mapValue instanceof String)) break;
            String objValue = (String)mapValue;
            if (StringUtils.isBlank((CharSequence)objValue)) continue;
            handleMaps.put(fields[idx], cryptor.apply(objValue));
        }
    }

    private static void cryptListFields(List<Object> mapList, String remainField, UnaryOperator<String> cryptor) {
        mapList.stream().filter(mapValue -> mapValue instanceof Map).map(mapValue -> (Map)mapValue).forEach(mapValue -> CryptUtil.cryptSpecialField(mapValue, remainField, cryptor));
    }

    public static Map<String, Object> deepCopyMaps(Object maps) {
        HashMap<String, Object> newMaps = new HashMap<String, Object>();
        if (maps instanceof Map) {
            newMaps.putAll((Map)maps);
            newMaps.entrySet().forEach(CryptUtil::copyMapEntries);
        }
        return newMaps;
    }

    private static void copyMapEntries(Map.Entry<String, Object> entry) {
        if (entry.getValue() instanceof Map) {
            entry.setValue(CryptUtil.deepCopyMaps(entry.getValue()));
        }
        if (entry.getValue() instanceof List) {
            entry.setValue(CryptUtil.copyListItems(entry.getValue()));
        }
    }

    private static List<Object> copyListItems(Object items) {
        ArrayList<Object> newList = new ArrayList<Object>();
        if (!(items instanceof List)) {
            return newList;
        }
        newList.addAll((Collection)items);
        for (int idx = 0; idx < newList.size(); ++idx) {
            if (!(newList.get(idx) instanceof Map)) continue;
            newList.set(idx, CryptUtil.deepCopyMaps(newList.get(idx)));
        }
        return newList;
    }

    private CryptUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

