/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PortCheckUtil {
    private static final Logger log = LoggerFactory.getLogger(PortCheckUtil.class);
    private static final String DEFAULT_LOCAL_ADDRESS = "127.0.0.1";
    private static final String APPLICATION_YAML = "application.yaml";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortAvailable(int port) {
        try (Socket socket = new Socket();){
            socket.bind(new InetSocketAddress(DEFAULT_LOCAL_ADDRESS, port));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("Server port {} has been used", (Object)port);
            return false;
        }
    }

    public static String getYamlPropertyValue(String key) {
        ClassPathResource resource = new ClassPathResource(APPLICATION_YAML);
        YamlPropertiesFactoryBean factoryBean = new YamlPropertiesFactoryBean();
        factoryBean.setResources(new Resource[]{resource});
        Properties properties = factoryBean.getObject();
        if (properties == null) {
            return "";
        }
        return properties.getProperty(key);
    }
}

