/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.bpm.util;

import com.huawei.ism.tool.lifecycle.model.stm.StmReportMessage;
import com.huawei.ism.tool.lifecycle.util.StmReportUtil;
import com.huawei.yinglong.bpm.dto.ProcessConfig;
import com.huawei.yinglong.bpm.dto.ProcessInstanceDto;
import com.huawei.yinglong.bpm.entity.DeployScene;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolLifecycleMessageReportUtil {
    private static final Logger log = LoggerFactory.getLogger(ToolLifecycleMessageReportUtil.class);
    private static final int DEFAULT_SERVICE_VOLUME = 1;

    public static void reportStmMessage(ProcessInstanceDto processInstanceDto) {
        if (processInstanceDto == null) {
            log.error("The current instance object is empty");
            return;
        }
        DeployScene deployScene = DeployScene.transferDeployScene(processInstanceDto.getType());
        if (deployScene == null) {
            log.error("current type {} not support", (Object)processInstanceDto.getType());
            return;
        }
        StmReportUtil.reportStmMessage((StmReportMessage)new StmReportMessage(deployScene.getFeatureId(), ToolLifecycleMessageReportUtil.buildServiceVolume(processInstanceDto.getProcessConfig())), (String)deployScene.getToolName());
    }

    private static int buildServiceVolume(Object processConfig) {
        if (Objects.isNull(processConfig) || !(processConfig instanceof ProcessConfig)) {
            return 1;
        }
        Object installMode = ((ProcessConfig)processConfig).getBusiness().get("installMode");
        if (Objects.isNull(installMode) || !(installMode instanceof List)) {
            return 1;
        }
        return ((List)installMode).size();
    }

    private ToolLifecycleMessageReportUtil() {
    }
}

