/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.spring.FitBeanNameGenerator;
import com.huawei.fitframework.spring.FitListableBeanFactory;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.lang.NonNull;

public class FitBeanDefinitionRegistryPostProcessor
implements BeanDefinitionRegistryPostProcessor {
    private final List<String> scanPackage;

    public FitBeanDefinitionRegistryPostProcessor(List<String> scanPackage) {
        this.scanPackage = scanPackage;
    }

    public void postProcessBeanDefinitionRegistry(@NonNull BeanDefinitionRegistry registry) throws BeansException {
        Validation.isTrue((boolean)(registry instanceof FitListableBeanFactory), (String)"Registry is not $FitListableBeanFactory.", (Object[])new Object[0]);
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(registry);
        FitBeanNameGenerator annotationBeanNameGenerator = new FitBeanNameGenerator();
        scanner.setBeanNameGenerator((BeanNameGenerator)annotationBeanNameGenerator);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(FitableSuite.class));
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Fitable.class));
        FitListableBeanFactory beanFactory = (FitListableBeanFactory)registry;
        DefaultResourceLoader resourceLoader = new DefaultResourceLoader(beanFactory.getBeanClassLoader());
        scanner.setResourceLoader((ResourceLoader)resourceLoader);
        scanner.scan(new String[]{String.join((CharSequence)"", this.scanPackage)});
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

