/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.spring.FitListableBeanFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.lang.NonNull;

public class FitBeanNameGenerator
extends AnnotationBeanNameGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitBeanNameGenerator.class);
    private static final Set<Class<? extends Annotation>> FIT_SERVICE_ANNOTATION_SET = new HashSet<Class<? extends Annotation>>(2);

    public String generateBeanName(@NonNull BeanDefinition definition, @NonNull BeanDefinitionRegistry registry) {
        return this.getName(definition, (FitListableBeanFactory)((Object)ObjectUtils.cast((Object)registry)));
    }

    private String getName(BeanDefinition definition, FitListableBeanFactory registry) {
        String beanClassName = definition.getBeanClassName();
        return this.isFitBean(beanClassName, registry) ? beanClassName : super.generateBeanName(definition, (BeanDefinitionRegistry)registry);
    }

    private boolean isFitBean(String beanClassName, FitListableBeanFactory factory) {
        try {
            Class<?> clazz = Objects.requireNonNull(factory.getBeanClassLoader()).loadClass(beanClassName);
            return Arrays.stream(clazz.getAnnotations()).anyMatch(annotation -> FIT_SERVICE_ANNOTATION_SET.contains(annotation.annotationType()));
        }
        catch (ClassNotFoundException e) {
            log.debug("Load class failed. [className={}, errorMsg={}]", new Object[]{beanClassName, e.getMessage(), e});
            log.error("Load class failed. [className={}, errorMsg={}]", (Object)beanClassName, (Object)e.getMessage());
            return false;
        }
    }

    static {
        FIT_SERVICE_ANNOTATION_SET.add(FitableSuite.class);
        FIT_SERVICE_ANNOTATION_SET.add(Fitable.class);
    }
}

