/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.spring.FitFieldElement;
import com.huawei.fitframework.spring.FitListableBeanFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class FitInstantiationAwareBeanPostProcessor
implements InstantiationAwareBeanPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitInstantiationAwareBeanPostProcessor.class);
    private static final Set<Class<? extends Annotation>> FIT_FIELD_ANNOTATION_SET = new HashSet<Class<? extends Annotation>>();
    private final FitListableBeanFactory beanFactory;
    private final Map<String, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap<String, InjectionMetadata>(256);

    public FitInstantiationAwareBeanPostProcessor(FitListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public PropertyValues postProcessProperties(@Nullable PropertyValues pvs, Object bean, @NonNull String beanName) {
        InjectionMetadata metadata = this.findResourceMetadata(beanName, bean.getClass(), pvs);
        try {
            metadata.inject(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of resource dependencies failed", ex);
        }
        return pvs;
    }

    private InjectionMetadata findResourceMetadata(String beanName, Class<?> clazz, PropertyValues pvs) {
        String cacheKey = StringUtils.hasLength((String)beanName) ? beanName : clazz.getName();
        InjectionMetadata metadata = this.injectionMetadataCache.get(cacheKey);
        return this.refreshIfNeed(metadata, clazz, cacheKey, pvs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata refreshIfNeed(InjectionMetadata metadata, Class<?> clazz, String cacheKey, PropertyValues pvs) {
        InjectionMetadata meta = metadata;
        if (!InjectionMetadata.needsRefresh((InjectionMetadata)meta, clazz)) {
            return meta;
        }
        Map<String, InjectionMetadata> map = this.injectionMetadataCache;
        synchronized (map) {
            meta = this.injectionMetadataCache.get(cacheKey);
            if (!InjectionMetadata.needsRefresh((InjectionMetadata)meta, clazz)) {
                return meta;
            }
            if (meta != null) {
                meta.clear(pvs);
            }
            meta = this.buildFitInjectionMetadata(clazz);
            this.injectionMetadataCache.put(cacheKey, meta);
        }
        return meta;
    }

    private InjectionMetadata buildFitInjectionMetadata(Class<?> clazz) {
        if (!AnnotationUtils.isCandidateClass(clazz, FIT_FIELD_ANNOTATION_SET)) {
            return InjectionMetadata.EMPTY;
        }
        ArrayList elements = new ArrayList();
        for (Class<?> target = clazz; target != null && target != Object.class; target = target.getSuperclass()) {
            List elementList = Stream.of(target.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Fit.class)).filter(field -> !Modifier.isStatic(field.getModifiers())).map(field -> new FitFieldElement(this.beanFactory, (Field)field)).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(elementList)) continue;
            elements.addAll(0, elementList);
        }
        return InjectionMetadata.forElements(elements, clazz);
    }

    static {
        FIT_FIELD_ANNOTATION_SET.add(Fit.class);
    }
}

