/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentCreationException;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.spring.FitInstantiationAwareBeanPostProcessor;
import com.huawei.fitframework.spring.support.SpringComponentRegistry;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.AutowiredAnnotationBeanPostProcessor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.CommonAnnotationBeanPostProcessor;
import org.springframework.context.annotation.ConfigurationClassPostProcessor;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.MethodMetadata;
import org.springframework.lang.NonNull;

public class FitListableBeanFactory
extends DefaultListableBeanFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FitListableBeanFactory.class);
    private static final Set<String> SPRING_WHITE_LIST = new HashSet<String>();
    private final Set<Class<?>> beanDefinitionClassSet = new HashSet();
    private final ComponentRegistry componentRegistry;
    private final ClassLoader classLoader;

    public FitListableBeanFactory(ComponentRegistry componentRegistry, ClassLoader classLoader) {
        this.componentRegistry = componentRegistry;
        this.classLoader = classLoader;
        this.addBeanPostProcessor((BeanPostProcessor)new FitInstantiationAwareBeanPostProcessor(this));
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public boolean containsBeanDefinition(@NonNull String beanName) {
        return super.containsBeanDefinition(beanName);
    }

    public void registerBeanDefinition(@NonNull String beanName, @NonNull BeanDefinition beanDefinition) {
        if (!this.registerable(beanDefinition)) {
            return;
        }
        log.info("|SpringFitInfo|RegisterBeanDefinition|contextName={}, beanName={}", (Object)this.componentRegistry.getName(), (Object)beanName);
        try {
            if (StringUtils.isNotBlank((String)beanDefinition.getBeanClassName())) {
                this.beanDefinitionClassSet.add(this.classLoader.loadClass(beanDefinition.getBeanClassName()));
            }
            super.registerBeanDefinition(beanName, beanDefinition);
        }
        catch (Exception e) {
            log.debug("Register bean failed. [beanName={}]", (Object)beanName, (Object)e);
            log.error("Register bean failed. [beanName={}]", (Object)beanName);
            throw new IllegalStateException(StringUtils.format((String)"Register bean failed. [beanName={0}]", (Object[])new Object[]{beanName}), e);
        }
    }

    private boolean registerable(BeanDefinition beanDefinition) {
        String className = Optional.ofNullable(beanDefinition.getBeanClassName()).orElseGet(() -> ((MethodMetadata)MethodMetadata.class.cast(beanDefinition.getSource())).getDeclaringClassName());
        return SPRING_WHITE_LIST.contains(className) || this.isClassExists(className);
    }

    private boolean isClassExists(String className) {
        URLClassLoader urlClassLoader = (URLClassLoader)ObjectUtils.cast((Object)this.classLoader);
        URL url = urlClassLoader.findResource(className.replace('.', '/').concat(".class"));
        return url != null;
    }

    @NonNull
    public BeanDefinition getBeanDefinition(@NonNull String beanName) throws BeansException {
        return super.getBeanDefinition(beanName);
    }

    @NonNull
    protected Object createBean(@NonNull String beanName, @NonNull RootBeanDefinition mbd, Object[] args) throws BeanCreationException {
        if (this.isSpringBean(mbd)) {
            return this.instantiate(mbd.getTargetType(), () -> super.createBean(beanName, mbd, args), this.classLoader);
        }
        Object bean = this.componentRegistry.getComponentFactory(mbd.getTargetType()).map(factory -> this.instantiate(factory.getComponentClass(), () -> factory.get(args), factory.getComponentClass().getClassLoader())).orElse(null);
        this.resolveSpringFields(bean);
        log.info("|SpringFitInfo|CreateBean|contextName={}, beanName={}", (Object)this.componentRegistry.getName(), (Object)beanName);
        return bean;
    }

    private boolean isSpringBean(RootBeanDefinition mbd) {
        return !mbd.getTargetType().isAnnotationPresent(FitableSuite.class) && !mbd.getTargetType().isAnnotationPresent(Fitable.class);
    }

    private void resolveSpringFields(Object objectBean) {
        Field[] declaredFields = objectBean.getClass().getDeclaredFields();
        Stream.of(declaredFields).filter(this::isAnnotatedBySpring).forEach(field -> this.resolveSpringField(objectBean, (Field)field));
    }

    private boolean isAnnotatedBySpring(Field field) {
        return field.isAnnotationPresent(Resource.class) || field.isAnnotationPresent(Autowired.class);
    }

    private void resolveSpringField(Object objectBean, Field field) {
        Class genericClass = (Class)field.getGenericType();
        Object fieldObj = Optional.ofNullable(this.getInterfaceProxy(genericClass, this.resolveName(field))).orElseGet(() -> this.getBean(genericClass));
        ReflectionUtils.setField((Object)objectBean, (Field)field, (Object)fieldObj);
    }

    private String resolveName(Field field) {
        return this.resolveResource(field).orElseGet(() -> this.resolveAutowired(field));
    }

    private Optional<String> resolveResource(Field field) {
        return Optional.ofNullable(field.getAnnotation(Resource.class)).map(Resource::name);
    }

    private String resolveAutowired(Field field) {
        return Optional.ofNullable(field.getAnnotation(Autowired.class)).flatMap(autowired -> Optional.ofNullable(field.getAnnotation(Qualifier.class)).map(Qualifier::value)).orElseGet(field::getName);
    }

    private Object getInterfaceProxy(Class<?> genericClass, String fieldBeanName) {
        if (!genericClass.isInterface()) {
            return null;
        }
        String[] beanNames = this.getBeanNamesForType(genericClass);
        return Arrays.stream(beanNames).filter(beanName -> beanName.equals(fieldBeanName) || StringUtils.isBlank((String)fieldBeanName)).findAny().map(arg_0 -> ((FitListableBeanFactory)this).getBean(arg_0)).orElse(null);
    }

    @NonNull
    public <T> T getBean(@NonNull Class<T> requiredType) throws BeansException {
        return (T)Optional.ofNullable(this.getInternalBean(requiredType)).orElseGet(() -> this.getExternalBean(factory -> factory.getInternalBean(requiredType)));
    }

    @NonNull
    public <T> T getBean(@NonNull Class<T> requiredType, Object ... args) throws BeansException {
        return (T)Optional.ofNullable(this.getInternalBean(requiredType, args)).orElseGet(() -> this.getExternalBean(factory -> factory.getInternalBean(requiredType, args)));
    }

    @NonNull
    public <T> ObjectProvider<T> getBeanProvider(@NonNull Class<T> requiredType) {
        return super.getBeanProvider(requiredType);
    }

    @NonNull
    public <T> ObjectProvider<T> getBeanProvider(@NonNull ResolvableType requiredType) {
        return super.getBeanProvider(requiredType);
    }

    private boolean containBeanDefinitionClass(Class<?> clazz) {
        return this.beanDefinitionClassSet.stream().anyMatch(clazz::isAssignableFrom);
    }

    private <T> T getInternalBean(Class<T> requiredType) {
        return (T)(this.containBeanDefinitionClass(requiredType) ? super.getBean(requiredType) : null);
    }

    private <T> T getInternalBean(Class<T> requiredType, Object ... args) {
        return (T)(this.containBeanDefinitionClass(requiredType) ? super.getBean(requiredType, args) : null);
    }

    private <T> T getExternalBean(Function<FitListableBeanFactory, T> beanMapper) {
        List componentRegistryList = this.componentRegistry.getContainer().getRegistries();
        List factoryList = componentRegistryList.stream().filter(registry -> registry instanceof SpringComponentRegistry).map(SpringComponentRegistry.class::cast).map(GenericApplicationContext::getBeanFactory).map(FitListableBeanFactory.class::cast).filter(factory -> factory != this).collect(Collectors.toList());
        for (FitListableBeanFactory factory2 : factoryList) {
            T object = beanMapper.apply(factory2);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    private <T> T instantiate(Class<?> componentClass, Supplier<T> beanSupplier, ClassLoader classLoader) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = beanSupplier.get();
            return t;
        }
        catch (Throwable t) {
            log.error("|SpringFitError|CreateBean|Fail to instantiate bean. [class={}]", (Object)componentClass.getName());
            if (t instanceof ComponentCreationException) {
                throw (ComponentCreationException)t;
            }
            throw new ComponentCreationException(componentClass, t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    static {
        SPRING_WHITE_LIST.add(AutowiredAnnotationBeanPostProcessor.class.getName());
        SPRING_WHITE_LIST.add(ConfigurationClassPostProcessor.class.getName());
        SPRING_WHITE_LIST.add(CommonAnnotationBeanPostProcessor.class.getName());
    }
}

