/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.spring.support;

import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentFactory;
import com.huawei.fitframework.ioc.ComponentRegistry;
import com.huawei.fitframework.ioc.support.DefaultComponentRegistry;
import com.huawei.fitframework.spring.FitListableBeanFactory;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringComponentRegistry
extends AnnotationConfigApplicationContext
implements ComponentRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringComponentRegistry.class);
    private boolean isRefreshed = false;

    public SpringComponentRegistry(ComponentContainer container, String name, ClassLoader classLoader) {
        super((DefaultListableBeanFactory)new FitListableBeanFactory((ComponentRegistry)new DefaultComponentRegistry(container, name), classLoader));
    }

    public String getName() {
        return this.getFitBeanFactory().getComponentRegistry().getName();
    }

    public ComponentContainer getContainer() {
        return this.getFitBeanFactory().getComponentRegistry().getContainer();
    }

    public void register(ComponentBrief brief) {
        this.getFitBeanFactory().getComponentRegistry().register(brief);
    }

    public void register(String componentName, Object component) {
        this.getFitBeanFactory().getComponentRegistry().register(componentName, component);
    }

    public void register(ComponentFactory factory) {
        this.getFitBeanFactory().getComponentRegistry().register(factory);
    }

    public void observeComponentRegistered(Consumer<ComponentBrief> observer) {
        this.getFitBeanFactory().getComponentRegistry().observeComponentRegistered(observer);
    }

    public void unobserveComponentRegistered(Consumer<ComponentBrief> observer) {
        this.getFitBeanFactory().getComponentRegistry().unobserveComponentRegistered(observer);
    }

    public Optional<ComponentFactory> getComponentFactory(String componentName) {
        return this.getFitBeanFactory().getComponentRegistry().getComponentFactory(componentName);
    }

    public List<ComponentFactory> listComponentFactories(Class<?> componentClass) {
        return this.getFitBeanFactory().getComponentRegistry().listComponentFactories(componentClass);
    }

    public List<ComponentFactory> listComponentFactories(Type componentType) {
        return this.getFitBeanFactory().getComponentRegistry().listComponentFactories(componentType);
    }

    public List<ComponentFactory> listComponentFactories() {
        return this.getFitBeanFactory().getComponentRegistry().listComponentFactories();
    }

    public void preloadSingletons() {
        log.debug("Preloading singleton components. [registry={}]", (Object)this.getName());
        int count = 0;
        for (ComponentFactory factory : this.listComponentFactories()) {
            if (!factory.isSingleton()) continue;
            DefaultComponentRegistry.instantiate((ComponentFactory)factory, (Object[])new Object[0]);
            ++count;
        }
        log.debug("Singleton components preloaded. Total {} components loaded!", (Object)count);
    }

    public void scan(String ... basePackages) {
        super.scan(basePackages);
    }

    public void refresh() {
        if (this.isRefreshed) {
            return;
        }
        super.refresh();
        this.isRefreshed = true;
    }

    private FitListableBeanFactory getFitBeanFactory() {
        return (FitListableBeanFactory)((Object)ObjectUtils.cast((Object)this.getBeanFactory()));
    }
}

