/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.sdk.system.system;

import com.huawei.fit.registry.entity.Address;
import com.huawei.fit.sdk.system.GetEnvironment;
import com.huawei.fit.sdk.system.GetLocalAddresses;
import com.huawei.fit.sdk.system.GetRegistryMatchedAddress;
import com.huawei.fit.sdk.system.GetSystemProperty;
import com.huawei.fit.sdk.system.SetLocalAddresses;
import com.huawei.fit.sdk.system.SetRegistryMatchedAddress;
import com.huawei.fit.sdk.system.SetSystemProperty;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class Properties {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Properties.class);
    private static final String WORKER_ENVIRONMENT = "worker.environment";
    private final AtomicReference<Address> registryMatchedLocalAddress = new AtomicReference();
    private final AtomicReference<List<Address>> localAddresses = new AtomicReference();
    private final Set<String> readOnlyKeys = ConcurrentHashMap.newKeySet();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final ReadWriteLock lock = LockUtils.newReentrantReadWriteLock();

    public Properties(@Value(value="${worker.environment}") String environment) {
        Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
        log.info("Config worker.environment is {}.", (Object)environment);
        this.setSystemProperty(WORKER_ENVIRONMENT, environment, true);
    }

    @Fitable(generic=GetSystemProperty.class, id="3c7d4d61322644568064275e0a88461f")
    public String getSystemProperty(String key) {
        if (StringUtils.isBlank((String)key)) {
            return null;
        }
        return (String)LockUtils.synchronize((Lock)this.lock.readLock(), () -> this.properties.get(key));
    }

    @Fitable(generic=SetSystemProperty.class, id="209a2812213b4669abd6ebded611904b")
    public Boolean setSystemProperty(String key, String value, Boolean readonly) {
        if (StringUtils.isBlank((String)key)) {
            log.warn("Fail to set system property: no key.");
            return false;
        }
        boolean isReadOnly = (Boolean)ObjectUtils.nullIf((Object)readonly, (Object)false);
        if (isReadOnly) {
            this.readOnlyKeys.add(key);
            log.info("Add read-only key successfully. [key={}]", (Object)key);
        }
        return LockUtils.synchronize((Lock)this.lock.writeLock(), () -> {
            if (this.readOnlyKeys.contains(key)) {
                return this.setReadOnlyValue(key, value);
            }
            this.properties.put(key, value);
            return true;
        });
    }

    @Fitable(generic=GetLocalAddresses.class, id="c6b45273f3cb4be383f07a996872bb44")
    public List<Address> getLocalAddresses() {
        if (this.localAddresses.get() == null) {
            return Collections.emptyList();
        }
        return this.localAddresses.get().stream().map(this::cloneAddress).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    @Fitable(generic=SetLocalAddresses.class, id="93c0558acc5945528db8ad38964dd59e")
    public Boolean setLocalAddresses(List<Address> addresses) {
        boolean ret = this.checkAddresses(addresses);
        if (!ret) {
            log.info("Fail to set local addresses: check addresses failed.");
            return false;
        }
        ret = this.localAddresses.compareAndSet(null, addresses);
        if (!ret) {
            log.warn("Fail to set local addresses: local addresses have already been set. [localAddresses={}, toSetAddresses={}]", this.localAddresses.get(), addresses);
            return false;
        }
        return true;
    }

    @Fitable(generic=GetRegistryMatchedAddress.class, id="cd61b40b47db4f349ec13f27375a9d84")
    public Address getRegistryMatchedAddress() {
        return this.cloneAddress(this.registryMatchedLocalAddress.get()).orElse(null);
    }

    @Fitable(generic=SetRegistryMatchedAddress.class, id="5689f4242c304a02b4027bab2acf5d69")
    public Boolean setRegistryMatchedAddress(Address address) {
        boolean ret = this.checkAddress(address);
        if (!ret) {
            log.info("Fail to set registry matched address: check address failed.");
            return false;
        }
        ret = this.registryMatchedLocalAddress.compareAndSet(null, address);
        if (!ret) {
            log.warn("Fail to set registry matched address: registry matched address has already been set. [registryMatchedAddress={}, toSetAddress={}]", (Object)this.registryMatchedLocalAddress.get(), (Object)address);
            return false;
        }
        return true;
    }

    @Fitable(generic=GetEnvironment.class, id="97d753edc29c45259895005608c0cb3f")
    public String getEnvironment() {
        return this.getSystemProperty(WORKER_ENVIRONMENT);
    }

    private boolean checkAddresses(List<Address> addresses) {
        List<Address> actualAddresses = addresses.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(actualAddresses)) {
            log.warn("Check addresses: no addresses.");
            return false;
        }
        return this.checkAddressesEnvironment(actualAddresses);
    }

    private boolean checkAddress(Address address) {
        if (address == null) {
            log.warn("Check address: no address.");
            return false;
        }
        return this.checkAddressesEnvironment(Collections.singletonList(address));
    }

    private boolean checkAddressesEnvironment(List<Address> addresses) {
        if (!this.hasTheSameEnvironment(addresses)) {
            log.warn("Check addresses environment: addresses have different environment. [addresses={}]", addresses);
            return false;
        }
        if (this.getEnvironment() != null && !this.hasTheSameEnvironmentWithCurrent(addresses.get(0))) {
            log.warn("Check addresses environment: address environment is different with current. [currentEnvironment={}, addressEnvironment={}]", (Object)this.getEnvironment(), (Object)addresses.get(0).getEnvironment());
            return false;
        }
        return true;
    }

    private boolean hasTheSameEnvironment(List<Address> addresses) {
        long environmentNum = addresses.stream().filter(Objects::nonNull).map(Address::getEnvironment).filter(StringUtils::isNotBlank).distinct().count();
        return environmentNum <= 1L;
    }

    private boolean hasTheSameEnvironmentWithCurrent(Address address) {
        return Objects.equals(this.getEnvironment(), address.getEnvironment());
    }

    private Optional<Address> cloneAddress(Address address) {
        if (address == null) {
            return Optional.empty();
        }
        return Optional.of(Address.builder().host(address.getHost()).port(address.getPort()).id(address.getId()).protocol(address.getProtocol()).formats(address.getFormats()).environment(address.getEnvironment()).build());
    }

    private boolean setReadOnlyValue(String key, String value) {
        if (!this.properties.containsKey(key)) {
            this.properties.put(key, value);
            log.info("Init read-only property to {}. [key={}]", (Object)value, (Object)key);
            return true;
        }
        String originValue = this.properties.get(key);
        if (Objects.equals(originValue, value)) {
            log.debug("Ignore setting read-only property to {}, because it has already been set to this value. [key={}]", (Object)value, (Object)key);
            return true;
        }
        log.warn("Fail to set read-only property to {}, because it has already been set to {}. [key={}]", new Object[]{value, originValue, key});
        return false;
    }
}

