/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.http.client;

import com.huawei.fit.hakuna.kernel.broker.client.RequestResponseV4;
import com.huawei.fit.hakuna.kernel.broker.client.entity.RequestContext;
import com.huawei.fit.hakuna.kernel.broker.shared.entity.FitResponse;
import com.huawei.fit.hakuna.shared.entity.Address;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.http.client.Response;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.RetryableException;
import com.huawei.fitframework.exception.SystemError;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class HttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final long DEFAULT_TIMEOUT = 3000L;
    private static final String FIT_METADATA = "FIT-METADATA";
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String CONTENT_TYPE_VALUE = "application/x-www-form-urlencoded";
    private static final String FIT_PATH = "/fit";
    private static final String PARAM_DATA = "data";
    private final int maxMetadataLength;

    public HttpClient(@Value(value="${client.max-metadata-length}") int maxMetadataLength) {
        this.maxMetadataLength = maxMetadataLength;
    }

    @Fitable(generic=RequestResponseV4.class, id="ac8270748dd64e26b1d84e2727a450bf")
    public FitResponse requestResponseV4(Address address, byte[] metadata, byte[] data, RequestContext requestContext) {
        Validation.notNull((Object)address, (String)"No address.", (Object[])new Object[0]);
        String actualHost = Validation.notBlank((String)address.getHost(), (String)"No host.", (Object[])new Object[0]);
        int actualPort = (Integer)Validation.notNull((Object)address.getPort(), (String)"No port.", (Object[])new Object[0]);
        Validation.notNull((Object)metadata, () -> new FitException(SystemError.INVALID_REQUEST_METADATA_ERROR.getCode(), SystemError.INVALID_REQUEST_METADATA_ERROR.getMessage()));
        Validation.lessThanOrEquals((int)metadata.length, (int)this.maxMetadataLength, () -> new FitException(SystemError.INVALID_REQUEST_METADATA_ERROR.getCode(), SystemError.INVALID_REQUEST_METADATA_ERROR.getMessage()));
        Validation.notNull((Object)data, (String)"No data.", (Object[])new Object[0]);
        Response response = this.getResponse(metadata, data, actualHost, actualPort, requestContext);
        String responseData = response.getResponseData();
        String responseMetadata = response.getResponseMetadata();
        Validation.notBlank((String)responseMetadata, () -> new FitException(SystemError.INVALID_RESPONSE_METADATA_ERROR.getCode(), SystemError.INVALID_RESPONSE_METADATA_ERROR.getMessage()));
        return FitResponse.builder().metadata(Base64.getDecoder().decode(responseMetadata)).data(Base64.getDecoder().decode(responseData)).build();
    }

    private Response getResponse(byte[] metadata, byte[] data, String actualHost, int actualPort, RequestContext requestContext) {
        try {
            String body = "data=" + Base64.getEncoder().encodeToString(data);
            HttpURLConnection connection = this.buildConnection(metadata, requestContext, actualHost, actualPort, body);
            this.sendRequest(body, connection);
            return this.receiveResult(connection);
        }
        catch (Throwable t) {
            log.error("request by http failed, host:{}, port:{}.", (Object)actualHost, (Object)actualPort);
            log.error("error: ", t);
            SystemError systemError = this.getSystemError(t);
            throw new RetryableException(systemError.getCode(), systemError.getMessage() + "[from httpClient]", t);
        }
    }

    private HttpURLConnection buildConnection(byte[] metadata, RequestContext requestContext, String actualHost, int actualPort, String body) throws IOException {
        URL realUrl = new URL(this.buildUrl(actualHost, actualPort));
        HttpURLConnection connection = (HttpURLConnection)ObjectUtils.cast((Object)realUrl.openConnection());
        int timeout = Math.toIntExact((Long)ObjectUtils.nullIf((Object)requestContext.getTimeout(), (Object)3000L));
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setRequestProperty(CONTENT_TYPE_KEY, CONTENT_TYPE_VALUE);
        connection.setRequestProperty(FIT_METADATA, Base64.getEncoder().encodeToString(metadata));
        connection.setRequestProperty("Content-Length", Integer.toString(body.length()));
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestMethod("POST");
        connection.setInstanceFollowRedirects(false);
        connection.setRequestProperty("accept", APPLICATION_OCTET_STREAM);
        connection.setUseCaches(false);
        connection.connect();
        return connection;
    }

    private void sendRequest(String body, HttpURLConnection connection) throws IOException {
        try (OutputStream outputStream = connection.getOutputStream();){
            byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
            outputStream.write(bytes);
            outputStream.flush();
        }
    }

    /*
     * Exception decompiling
     */
    private Response receiveResult(HttpURLConnection connection) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String buildUrl(String actualHost, int actualPort) {
        return StringUtils.format((String)"http:////{0}:{1}{2}", (Object[])new Object[]{actualHost, actualPort, FIT_PATH});
    }

    private SystemError getSystemError(Throwable throwable) {
        if (throwable instanceof SocketTimeoutException) {
            return SystemError.TIMEOUT_ERROR;
        }
        if (throwable instanceof UnknownServiceException || throwable instanceof ProtocolException) {
            return SystemError.NETWORK_CONNECTION_ERROR;
        }
        return SystemError.DEFAULT_NETWORK_ERROR;
    }
}

