/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch;

import com.huawei.fitframework.launch.exception.FitFrameworkStartupException;
import com.huawei.fitframework.launch.loader.ClassLoaderSupplier;
import com.huawei.fitframework.launch.loader.support.DefaultClassLoaderSupplier;
import com.huawei.fitframework.launch.timer.StartupTimer;
import com.huawei.fitframework.launch.timer.support.DefaultStartupTimer;
import com.huawei.fitframework.launch.util.ArgumentUtils;
import com.huawei.fitframework.launch.util.ClassLoaderUtils;
import com.huawei.fitframework.launch.util.FileUtils;
import com.huawei.fitframework.launch.util.ProcessUtils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class FitLauncher {
    private static final List<String> DEFAULT_PARENT_CLASS_LOADER_NAMES = Arrays.asList("ExtClassLoader", "PlatformClassLoader");
    private static final String SEPARATOR_VALUE = ",";
    private static final String SHARED_PARENT_FOLDER = "shared";
    private static final String FRAMEWORK_PARENT_FOLDER = "platform";
    private static final List<String> FRAMEWORK_FOLDERS = Arrays.asList("converter", "lib", "third-party");
    private static final String RUNTIME_CLASS_NAME = "com.huawei.fitframework.runtime.FitRuntime";
    private static final String MAIN = "start";
    private static final String DATA_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private final String[] args;
    private final ClassLoader frameworkClassLoader;
    private final ClassLoaderSupplier classLoaderSupplier;

    FitLauncher(String[] args, ClassLoader sharedClassLoader, ClassLoaderSupplier classLoaderSupplier) {
        this.args = args;
        this.classLoaderSupplier = classLoaderSupplier;
        this.frameworkClassLoader = this.createFrameworkClassLoader(sharedClassLoader);
    }

    public static void main(String[] args) {
        try {
            FitLauncher.start(args, null);
        }
        catch (FitFrameworkStartupException e) {
            System.err.printf(Locale.ROOT, "%s %s ERROR %s%n", LocalDateTime.now().format(DateTimeFormatter.ofPattern(DATA_TIME_PATTERN)), Thread.currentThread().getName(), e.getMessage());
        }
    }

    public static Object start(String[] args, ClassLoader sharedClassLoader) {
        try (DefaultStartupTimer timer = new DefaultStartupTimer();){
            Object object = FitLauncher.start(args, sharedClassLoader, timer);
            return object;
        }
    }

    private static Object start(String[] args, ClassLoader sharedClassLoader, StartupTimer timer) {
        String[] actualArgs = args != null ? args : new String[]{};
        FitLauncher launcher = new FitLauncher(actualArgs, sharedClassLoader, new DefaultClassLoaderSupplier());
        Object fitContext = launcher.getEntryClass().flatMap(launcher::getEntryMethod).filter(launcher::isStatic).map(method -> launcher.invoke((Method)method, timer.getStartTime(), actualArgs)).orElse(null);
        ArgumentUtils.getProcessIdFile(actualArgs).map(FileUtils::canonicalize).ifPresent(ProcessUtils::writeProcessId);
        return fitContext;
    }

    private ClassLoader createFrameworkClassLoader(ClassLoader sharedClassLoader) {
        ClassLoader actualSharedClassLoader = sharedClassLoader != null ? sharedClassLoader : this.createSharedClassLoader();
        Path frameworkParent = this.getFrameworkDirectory().toPath().resolve(FRAMEWORK_PARENT_FOLDER);
        List<File> frameworkDirectories = FRAMEWORK_FOLDERS.stream().map(frameworkParent::resolve).map(Path::toFile).collect(Collectors.toList());
        return this.classLoaderSupplier.getFrameworkClassLoader(frameworkDirectories, actualSharedClassLoader);
    }

    private ClassLoader createSharedClassLoader() {
        ClassLoader parentLoader = ClassLoaderUtils.lookupClassLoader(classLoader -> DEFAULT_PARENT_CLASS_LOADER_NAMES.contains(classLoader.getClass().getSimpleName()));
        return this.classLoaderSupplier.getSharedClassLoader(this.getSharedDirectories(), parentLoader);
    }

    private File getFrameworkDirectory() {
        String directoryValue = ArgumentUtils.getFrameworkDirectory(this.args).orElse(".");
        File directory = FileUtils.canonicalize(directoryValue);
        if (!directory.isDirectory()) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: invalid framework directory. [frameworkDirectory=%s]", directory.getPath()));
        }
        return directory;
    }

    private List<File> getSharedDirectories() {
        File shared = this.getFrameworkDirectory().toPath().resolve(SHARED_PARENT_FOLDER).toFile();
        List actualSharedDirectories = ArgumentUtils.getSharedDirectories(this.args).map(sharedDirectories -> Arrays.stream(sharedDirectories.split(SEPARATOR_VALUE)).filter(Objects::nonNull).filter(sharedDirectory -> !sharedDirectory.isEmpty()).map(FileUtils::canonicalize).collect(Collectors.toList())).orElseGet(ArrayList::new);
        actualSharedDirectories.add(shared);
        return actualSharedDirectories;
    }

    private Optional<Class<?>> getEntryClass() {
        try {
            return Optional.of(this.frameworkClassLoader.loadClass(RUNTIME_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no entry class. [entryClass=%s]", RUNTIME_CLASS_NAME), e);
        }
    }

    private Optional<Method> getEntryMethod(Class<?> runtimeClass) {
        try {
            return Optional.of(runtimeClass.getDeclaredMethod(MAIN, Long.TYPE, String[].class));
        }
        catch (NoSuchMethodException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no entry method. [entryMethod=%s#%s(long startTime, String[] args)]", RUNTIME_CLASS_NAME, MAIN), e);
        }
    }

    private boolean isStatic(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return true;
        }
        throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: the entry method is not a valid Java main method. [methodModifiers=%s]", Modifier.toString(method.getModifiers())));
    }

    private Object invoke(Method method, long startTime, String[] args) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.frameworkClassLoader);
            Object object = method.invoke(null, startTime, args);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: no access to invoke entry method. [methodModifiers=%s]", Modifier.toString(method.getModifiers())), e);
        }
        catch (InvocationTargetException e) {
            throw new FitFrameworkStartupException(String.format(Locale.ROOT, "Fail to start fit runtime: exception occurs. Below is error summary, for details, see log please. [exception=%s:%s]", this.getExceptionName(e.getCause()), this.getExceptionReason(e.getCause())), e.getCause());
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private String getExceptionReason(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Throwable::getMessage).orElse("No exception");
    }

    private String getExceptionName(Throwable throwable) {
        return Optional.ofNullable(throwable).map(Object::getClass).map(Class::getSimpleName).orElse("Unknown");
    }
}

