/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch.loader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FrameworkClassLoader
extends URLClassLoader {
    private Consumer<List<URL>> urlObserver;

    public FrameworkClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addUrls(List<URL> urls) {
        if (urls == null || urls.isEmpty()) {
            return;
        }
        List<URL> actualUrls = urls.stream().filter(Objects::nonNull).collect(Collectors.toList());
        actualUrls.forEach(this::addURL);
        Optional.ofNullable(this.urlObserver).ifPresent(urlConsumer -> urlConsumer.accept(actualUrls));
    }

    public void setUrlObserver(Consumer<List<URL>> urlObserver) {
        this.urlObserver = urlObserver;
    }
}

