/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class ArgumentUtils {
    private static final String KEY_FRAMEWORK_DIRECTORY = "framework.directory";
    private static final String KEY_SHARED_DIRECTORIES = "shared.directories";
    private static final String KEY_WORKER_PROCESS_ID_FILE = "worker.process-id.file";
    private static final String SEPARATOR_KEY_VALUE = "=";

    public static Optional<String> getFrameworkDirectory(String[] args) {
        return ArgumentUtils.getArgByCondition(args, arg -> arg.startsWith("framework.directory="));
    }

    public static Optional<String> getSharedDirectories(String[] args) {
        return ArgumentUtils.getArgByCondition(args, arg -> arg.startsWith("shared.directories="));
    }

    public static Optional<String> getProcessIdFile(String[] args) {
        return ArgumentUtils.getArgByCondition(args, arg -> arg.startsWith("worker.process-id.file="));
    }

    private static Optional<String> getArgByCondition(String[] args, Predicate<String> predicate) {
        return Stream.of(args).filter(Objects::nonNull).filter(predicate).findFirst().map(arg -> arg.substring(arg.indexOf(SEPARATOR_KEY_VALUE) + 1)).map(String::trim).filter(value -> !value.isEmpty());
    }
}

