/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class FileUtils {
    public static final String CURRENT_DIRECTORY = ".";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final URL[] EMPTY_URL_ARRAY = new URL[0];

    private FileUtils() {
    }

    public static File canonicalize(String fileName) {
        File file = new File(fileName);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Fail to canonicalize file. [fileName=%s]", fileName), e);
        }
    }

    public static URL[] resolveJarUrls(List<File> files) {
        if (files == null || files.isEmpty()) {
            return EMPTY_URL_ARRAY;
        }
        ArrayList jarUrls = new ArrayList();
        files.stream().filter(Objects::nonNull).filter(FileUtils::isFileOrDirectory).forEach(file -> FileUtils.resolveFileOrDirectory(jarUrls, file));
        return jarUrls.toArray(EMPTY_URL_ARRAY);
    }

    private static boolean isFileOrDirectory(File file) {
        return file.isFile() || file.isDirectory();
    }

    private static void resolveFileOrDirectory(List<URL> urls, File file) {
        if (file.isFile()) {
            FileUtils.resolveJarUrl(urls, file);
        } else {
            FileUtils.resolveJarUrls(urls, file);
        }
    }

    private static void resolveJarUrl(List<URL> urls, File file) {
        if (FileUtils.isJar(file)) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Fail to convert local file to URL.", e);
            }
        }
    }

    private static void resolveJarUrls(List<URL> urls, File directory) {
        File[] files = directory.listFiles();
        if (files == null || files.length <= 0) {
            return;
        }
        Arrays.stream(files).filter(Objects::nonNull).filter(FileUtils::isFileOrDirectory).forEach(file -> FileUtils.resolveFileOrDirectory(urls, file));
    }

    private static boolean isJar(File file) {
        return file.getName().endsWith(JAR_FILE_EXTENSION);
    }
}

