/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.launch.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Locale;

public class ProcessUtils {
    public static void writeProcessId(File processIdFile) {
        if (processIdFile == null) {
            return;
        }
        String content = String.format(Locale.ROOT, "process.id=%d", ProcessUtils.getProcessId());
        try (FileOutputStream output = new FileOutputStream(processIdFile, true);){
            ((OutputStream)output).write(content.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Fail to write process-id to file. [file=%s]", processIdFile.getPath()), e);
        }
    }

    public static int getProcessId() {
        return Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
    }
}

