/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.software.bpm;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.exception.FitException;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.yinglong.bpm.BpmContextService;
import com.huawei.yinglong.distributed.software.entity.SoftwareInstallParams;
import com.huawei.yinglong.smartkit.base.util.FilePathUtils;
import com.huawei.yinglong.smartkit.base.util.SystemEnvUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.camunda.bpm.client.spring.annotation.ExternalTaskSubscription;
import org.camunda.bpm.client.task.ExternalTaskHandler;
import org.camunda.bpm.engine.RuntimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

@Fitable
public class SoftwareInstallationTask {
    private static final Logger log = LoggerFactory.getLogger(SoftwareInstallationTask.class);
    private static final String DEVICE_MANAGER_CLIENT_BAT_PATH = new File(SystemEnvUtil.getDefaultUserDir()).getParent() + File.separator + "FusionStorageDeviceManagerClient" + File.separator + "%s" + File.separator + "%s" + File.separator + "run.bat";
    private static final List<String> SUPPORT_VERSIONS = Arrays.asList("8.1.5", "8.2.0", "8.2.1");
    private final RuntimeService runtimeService;
    private final BpmContextService bpmContextService;

    @ExternalTaskSubscription(value="startSoftwareInstallation")
    @Bean
    public ExternalTaskHandler startSoftwareInstallation() {
        return (externalTask, externalTaskService) -> {
            log.info("start software installation.");
            SoftwareInstallParams params = this.bpmContextService.getContext(externalTask.getExecutionId(), SoftwareInstallParams.class);
            params.setTaskId(externalTask.getProcessInstanceId());
            try {
                SoftwareInstallationTask.startTool(params.getSoftwareVersion());
                Thread.sleep(30000L);
                this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
            }
            catch (FitException | InterruptedException e) {
                log.error("start software installation failed.", e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
            }
        };
    }

    @ExternalTaskSubscription(value="loopSoftwareInstall", lockDuration=1000L)
    @Bean
    public ExternalTaskHandler loopSoftwareInstall() {
        return (externalTask, externalTaskService) -> {
            File runningFlag;
            log.info("start loopSoftwareInstall.");
            SoftwareInstallParams params = this.bpmContextService.getContext(externalTask.getExecutionId(), SoftwareInstallParams.class);
            try {
                runningFlag = new File(SoftwareInstallationTask.getDeviceManagerClientBatFile(params.getSoftwareVersion()).getParent(), "runningFlag");
                if (!runningFlag.exists()) {
                    this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                    return;
                }
            }
            catch (FitException e) {
                log.error("runningFlag file is not found.", (Throwable)e);
                this.bpmContextService.notifyInvocationFailed(externalTask, externalTaskService);
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(runningFlag);
                 FileLock fileLock = fos.getChannel().tryLock();){
                if (fileLock != null) {
                    this.bpmContextService.notifyInvocationFinished(externalTask, externalTaskService);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }

    private static void startTool(String softwareVersion) throws FitException {
        File jreDir = new File(new File(SystemEnvUtil.getDefaultUserDir()).getParentFile().getParentFile(), "jre");
        String jreCmd = SoftwareInstallationTask.getPathInCmd(FilePathUtils.getCanonicalPath((File)new File(jreDir, "bin" + File.separator + "java.exe")));
        String executorCmd = SoftwareInstallationTask.getPathInCmd(FilePathUtils.getCanonicalPath((File)SoftwareInstallationTask.getExecutorFile()));
        File clientBatFile = SoftwareInstallationTask.getDeviceManagerClientBatFile(softwareVersion);
        String startToolCmd = SoftwareInstallationTask.getPathInCmd(FilePathUtils.getCanonicalPath((File)clientBatFile));
        String cmd = String.format(Locale.ROOT, "CMD /C %s -jar %s %s", jreCmd, executorCmd, startToolCmd);
        log.info("execute cmd : {}", (Object)cmd);
        String result = OSCmdUtils.executeCmd((String)cmd, (int)60);
        log.info("execute result : {}", (Object)result);
    }

    @NonNull
    private static File getExecutorFile() throws FitException {
        String executorPath = SystemEnvUtil.getDefaultUserDir() + File.separator + "lib" + File.separator + "%s";
        File executor = new File(String.format(Locale.ROOT, executorPath, "executor.jar"));
        if (executor.exists()) {
            return executor;
        }
        File executorShot = new File(String.format(Locale.ROOT, executorPath, "executor-1.0-SNAPSHOT.jar"));
        if (executorShot.exists()) {
            return executorShot;
        }
        throw new FitException("executor file not found");
    }

    @NonNull
    public static File getDeviceManagerClientBatFile(String softwareVersion) throws FitException {
        String version = SUPPORT_VERSIONS.stream().filter(softwareVersion::contains).findFirst().orElse("8.2.0");
        String filePath = String.format(Locale.ROOT, DEVICE_MANAGER_CLIENT_BAT_PATH, SystemEnvUtil.getLanguage().getLanguage(), version);
        File batFile = new File(filePath);
        if (batFile.exists()) {
            return batFile;
        }
        throw new FitException(String.format("file %s not found", filePath));
    }

    private static String getPathInCmd(String path) {
        return path.replace(" ", "\" \"");
    }

    public SoftwareInstallationTask(RuntimeService runtimeService, BpmContextService bpmContextService) {
        this.runtimeService = runtimeService;
        this.bpmContextService = bpmContextService;
    }
}

