/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.operalogmanager.service;

import com.huawei.ism.tool.operalogmanager.entity.OperaLog;
import com.huawei.ism.tool.operalogmanager.util.OperaLogUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaLogService {
    private static final Logger log = LoggerFactory.getLogger(OperaLogService.class);
    private static final String LOGFILE_FULL_PATH = OperaLogUtil.getOperaLogPath() + File.separator;
    private static final String LOGFILE_NAME = "operalog.log";
    private BlockingQueue blockingQueue = new LinkedBlockingQueue(100);
    private ThreadPoolExecutor threadPool = new ThreadPoolExecutor(2, 64, 60L, TimeUnit.SECONDS, this.blockingQueue);

    public void addOperaLog(OperaLog operaLog) {
        if (operaLog == null || OperaLogUtil.isNULLStr(operaLog.getOperaName())) {
            throw new IllegalArgumentException();
        }
        log.info("execute add opera log task");
        this.threadPool.execute(new OperaLogAddTask(operaLog.copy()));
    }

    public void clearOperaLogAddTask() {
        log.info("clear opera log task");
        this.threadPool.shutdown();
        this.threadPool = null;
    }

    private class OperaLogAddTask
    implements Runnable {
        private OperaLog operaLog;
        private File logFile;

        public OperaLogAddTask(OperaLog operaLog) {
            this.operaLog = operaLog;
            this.logFile = new File(LOGFILE_FULL_PATH + OperaLogService.LOGFILE_NAME);
        }

        @Override
        public void run() {
            File workPath = new File(LOGFILE_FULL_PATH);
            if (!workPath.exists() && !workPath.mkdirs()) {
                log.error("create opera log work path exception.");
                return;
            }
            try {
                String logString = OperaLogUtil.operaLogToString(this.operaLog);
                Files.write(Paths.get(LOGFILE_FULL_PATH, OperaLogService.LOGFILE_NAME), Collections.singletonList(logString), StandardOpenOption.APPEND);
            }
            catch (FileNotFoundException e) {
                log.error("opera log file not exist!!!!");
            }
            catch (IOException e) {
                log.error("add opera log failed!!!!", e);
            }
        }
    }
}

