/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.operalogmanager.util;

import com.huawei.ism.tool.operalogmanager.entity.OperaLog;
import com.huawei.ism.tool.operalogmanager.service.OperaLogService;
import com.huawei.ism.tool.operalogmanager.util.AESEncrypt;
import java.io.File;
import java.nio.file.Paths;

public class OperaLogUtil {
    private static final String FIELD_DIVIDE = "#,#";
    private static final String TOOLS_PATH = "tools";
    private static OperaLogService logService = null;

    public static String operaLogToString(OperaLog operaLog) {
        String operaLogString = String.join((CharSequence)FIELD_DIVIDE, operaLog.getOperaName(), operaLog.getOperateType(), String.valueOf(operaLog.getLevel().ordinal()), String.valueOf(operaLog.getOperateDate().getTime()), operaLog.getDeviceName(), String.valueOf(operaLog.isResult()), operaLog.getUserName(), operaLog.getResultView(), String.valueOf(operaLog.isResultHasReport()), operaLog.getDeviceNameEn(), operaLog.getDetailInfo());
        return AESEncrypt.encrypt(operaLogString);
    }

    public static boolean isNULLStr(String str) {
        return str == null || "".equals(str.trim());
    }

    public static String getToolBoxWorkPath() {
        String dir = System.getProperty("user.dir");
        return dir.contains(TOOLS_PATH) ? dir.split(TOOLS_PATH)[0] : dir + File.separator;
    }

    public static String getOperaLogPath() {
        return Paths.get(OperaLogUtil.getToolBoxWorkPath(), "data", "operalog").toString();
    }

    public static void addOperaLog(OperaLog operaLog) {
        if (logService == null) {
            logService = new OperaLogService();
        }
        logService.addOperaLog(operaLog);
    }

    public static void addOperaLog(String operaName, String operateType, String deviceName, String deviceNameEn, String detailInfo) {
        if (logService == null) {
            logService = new OperaLogService();
        }
        OperaLog operaLog = new OperaLog();
        operaLog.setOperaName(operaName);
        operaLog.setOperateType(operateType);
        operaLog.setDeviceName(deviceName);
        operaLog.setDeviceNameEn(deviceNameEn);
        operaLog.setDetailInfo(detailInfo);
        operaLog.setUserName(System.getProperty("user.name"));
        operaLog.setLevel(OperaLog.OperaLevel.COMM);
        logService.addOperaLog(operaLog);
    }

    public static void clearTask() {
        if (logService == null) {
            return;
        }
        logService.clearOperaLogAddTask();
        logService = null;
    }
}

