/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.util;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;

public class AnnotationUtils {
    private static final String GENERICABLE_METHOD_NAME = "process";
    private static final String GENERIC_ID_FIELD_NAME = "GENERIC_ID";

    private AnnotationUtils() {
    }

    public static boolean isGenericableInterface(Class<?> genericableClass) {
        if (genericableClass == null || !genericableClass.isInterface()) {
            return false;
        }
        return genericableClass.getDeclaredAnnotation(Genericable.class) != null;
    }

    public static boolean isNotGenericableInterface(Class<?> genericableClass) {
        return !AnnotationUtils.isGenericableInterface(genericableClass);
    }

    public static String getGenericableId(Class<?> genericableClass) {
        Validation.notNull(genericableClass, (String)"Class of genericable cannot be null.", (Object[])new Object[0]);
        if (!genericableClass.isInterface()) {
            throw new IllegalArgumentException(StringUtils.format((String)"Class of genericable is not a interface. [class={0}]", (Object[])new Object[]{genericableClass.getName()}));
        }
        Genericable annotation = genericableClass.getAnnotation(Genericable.class);
        if (annotation == null) {
            throw new IllegalArgumentException(StringUtils.format((String)"Missing annotation declared on genericable class. [genericable={0}, annotation={1}]", (Object[])new Object[]{genericableClass.getName(), Genericable.class.getName()}));
        }
        return annotation.value();
    }

    public static Method getGenericableMethod(Class<?> genericableClass) {
        Validation.notNull(genericableClass, (String)"Class of genericable cannot be null.", (Object[])new Object[0]);
        Method[] methods = ReflectionUtils.getDeclaredMethods(genericableClass);
        Method genericableMethod = null;
        for (Method method : methods) {
            if (!AnnotationUtils.isGenericableMethod(method)) continue;
            if (genericableMethod == null) {
                genericableMethod = method;
                continue;
            }
            throw new IllegalStateException(StringUtils.format((String)"Multiply genericable methods declared. [class={0}]", (Object[])new Object[]{genericableClass.getName()}));
        }
        if (genericableMethod == null) {
            throw new IllegalStateException(StringUtils.format((String)"No genericable method declared. [class={0}]", (Object[])new Object[]{genericableClass.getName()}));
        }
        return genericableMethod;
    }

    public static boolean isGenericableMethod(Method method) {
        if (method == null) {
            return false;
        }
        return !Modifier.isStatic(method.getModifiers()) && StringUtils.equals((String)method.getName(), (String)GENERICABLE_METHOD_NAME);
    }

    public static boolean isMacroGenericableInterface(Class<?> genericableClass) {
        if (AnnotationUtils.isNotGenericableInterface(genericableClass)) {
            return false;
        }
        Field[] declaredFields = genericableClass.getDeclaredFields();
        if (declaredFields.length <= 0 || !StringUtils.equals((String)declaredFields[0].getName(), (String)GENERIC_ID_FIELD_NAME)) {
            return false;
        }
        Method[] declaredMethods = genericableClass.getDeclaredMethods();
        return declaredMethods.length == 1 && AnnotationUtils.isGenericableMethod(declaredMethods[0]);
    }

    public static boolean isFitAnnotationDeclared(AnnotatedElement element) {
        return Optional.ofNullable(element).map(ele -> ele.getDeclaredAnnotation(Fit.class)).isPresent();
    }

    public static Optional<String> getQualifiedAlias(AnnotatedElement element) {
        return Optional.ofNullable(element).map(ele -> ele.getDeclaredAnnotation(Fit.class)).map(Fit::alias).filter(StringUtils::isNotBlank);
    }

    public static String getQualifiedPolicy(AnnotatedElement element) {
        return Optional.ofNullable(element).map(ele -> ele.getDeclaredAnnotation(Fit.class)).map(AnnotationUtils::getPolicy).orElse(null);
    }

    private static String getPolicy(Fit fit) {
        if (StringUtils.isNotBlank((String)fit.alias())) {
            return "ALIAS";
        }
        return fit.policy();
    }

    public static Optional<Fit> getFitAnnotation(AnnotatedElement element) {
        return Optional.ofNullable(element).map(ele -> ele.getDeclaredAnnotation(Fit.class));
    }
}

