/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableFitableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableRouteConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableRuleRouteConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableTaggerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableTrustConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.GenericableType;
import com.huawei.fitframework.broker.conf.RuleRoutePolicy;
import com.huawei.fitframework.broker.conf.util.ValueUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationConfigurator
implements ConfigurationConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationConfigurator.class);
    private static final String KEY_GENERICABLE_NAME = "name";
    private static final String KEY_GENERICABLE_TYPE = "type";
    private static final String KEY_GENERICABLE_TAGS = "tags";
    private static final String KEY_GENERICABLE_ROUTE = "route";
    private static final String KEY_GENERICABLE_TRUST = "trust";
    private static final String KEY_GENERICABLE_PARAMS = "params";
    private static final String KEY_GENERICABLE_FITABLES = "fitables";
    private static final String KEY_GENERICABLE_DEFAULT = "default";
    private static final String KEY_FITABLE_ALIASES = "aliases";
    private static final String KEY_FITABLE_TAGS = "tags";
    private static final String KEY_FITABLE_DEGRADATION = "degradation";
    private static final String KEY_ROUTE_DEFAULT = "default";
    private static final String KEY_ROUTE_RULE = "rule";
    private static final String KEY_RULE_ROUTE_ID = "id";
    private static final String KEY_RULE_ROUTE_TYPE = "type";
    private static final String KEY_TRUST_VALIDATE = "validate";
    private static final String KEY_TRUST_BEFORE = "before";
    private static final String KEY_TRUST_AFTER = "after";
    private static final String KEY_TRUST_ERROR = "error";
    private static final String KEY_TAGGER_TAG = "tag";
    private static final String KEY_TAGGER_RULE_ID = "rule-id";
    private static final String KEY_PARAM_INDEX = "index";
    private static final String KEY_PARAM_TYPE = "type";
    private static final String KEY_PARAM_TAGGERS = "taggers";

    @Override
    public void configure(ConfigurableBrokerConfiguration config, Map<String, Object> values) {
        Map genericables = (Map)ValueUtils.cast(values.get("genericables"));
        genericables = (Map)ObjectUtils.nullIf((Object)genericables, Collections.emptyMap());
        genericables.entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> this.configure(config.getOrCreateGenericable((String)entry.getKey()), (Map<String, Object>)((Map)ValueUtils.cast(entry.getValue()))));
    }

    @Override
    public void configure(ConfigurableGenericableConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_GENERICABLE_NAME, "type", "tags", KEY_GENERICABLE_ROUTE, KEY_GENERICABLE_TRUST, KEY_GENERICABLE_PARAMS, KEY_GENERICABLE_FITABLES, "default");
        configuration.name(ValueUtils.stringValue(values, KEY_GENERICABLE_NAME, configuration.name()));
        configuration.type(GenericableType.fromCode(ValueUtils.stringValue(values, "type")).orElse(GenericableType.DEFAULT));
        HashSet<String> tags = new HashSet<String>(configuration.tags());
        tags.addAll(ValueUtils.stringCollection(values, "tags", HashSet::new));
        configuration.tags(tags);
        this.configure(configuration.route(), ValueUtils.children(values, KEY_GENERICABLE_ROUTE));
        this.configure(configuration.trust(), ValueUtils.children(values, KEY_GENERICABLE_TRUST));
        Map<String, Object> params = ValueUtils.children(values, KEY_GENERICABLE_PARAMS);
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            this.configure(configuration.getOrCreateParam(entry.getKey()), (Map<String, Object>)((Map)ValueUtils.cast(entry.getValue())));
        }
        Map<String, Object> fitables = ValueUtils.children(values, KEY_GENERICABLE_FITABLES);
        for (Map.Entry<String, Object> entry : fitables.entrySet()) {
            this.configure(configuration.getOrCreateFitable(entry.getKey()), (Map<String, Object>)((Map)ValueUtils.cast(entry.getValue())));
        }
        String string = ValueUtils.stringValue(values, "default");
        if (StringUtils.isNotBlank((String)string)) {
            configuration.route().defaultFitable(string);
        }
    }

    @Override
    public void configure(ConfigurableFitableConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_FITABLE_ALIASES, "tags", KEY_FITABLE_DEGRADATION);
        configuration.aliases(ValueUtils.stringCollection(values, KEY_FITABLE_ALIASES, HashSet::new));
        configuration.tags(ValueUtils.stringCollection(values, "tags", HashSet::new));
        configuration.degradationFitable(ValueUtils.stringValue(values, KEY_FITABLE_DEGRADATION, configuration.degradationFitable()));
    }

    @Override
    public void configure(ConfigurableRouteConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, "default", KEY_ROUTE_RULE);
        configuration.defaultFitable(ValueUtils.stringValue(values, "default"));
        this.configure(configuration.rule(), ValueUtils.children(values, KEY_ROUTE_RULE));
    }

    @Override
    public void configure(ConfigurableRuleRouteConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_RULE_ROUTE_ID, "type");
        configuration.id(ValueUtils.stringValue(values, KEY_RULE_ROUTE_ID));
        configuration.policies(RuleRoutePolicy.fromCodes(ValueUtils.stringValue(values, "type")));
    }

    @Override
    public void configure(ConfigurableTrustConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_TRUST_VALIDATE, KEY_TRUST_BEFORE, KEY_TRUST_AFTER, KEY_TRUST_ERROR);
        configuration.validate(ValueUtils.stringValue(values, KEY_TRUST_VALIDATE, configuration.validate()));
        configuration.before(ValueUtils.stringValue(values, KEY_TRUST_BEFORE, configuration.before()));
        configuration.after(ValueUtils.stringValue(values, KEY_TRUST_AFTER, configuration.after()));
        configuration.error(ValueUtils.stringValue(values, KEY_TRUST_ERROR, configuration.error()));
    }

    @Override
    public void configure(ConfigurableTaggerConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_TAGGER_TAG, KEY_TAGGER_RULE_ID);
        configuration.tag(ValueUtils.stringValue(values, KEY_TAGGER_TAG, configuration.tag()));
        configuration.rule(ValueUtils.stringValue(values, KEY_TAGGER_RULE_ID, configuration.rule()));
    }

    @Override
    public void configure(ConfigurableGenericableParamConfiguration configuration, Map<String, Object> values) {
        this.checkConfigValueKeys(values, KEY_PARAM_INDEX, "type", KEY_PARAM_TAGGERS);
        configuration.index(ValueUtils.integerValue(values, KEY_PARAM_INDEX, configuration.index()));
        configuration.type(ValueUtils.stringValue(values, "type", configuration.type()));
        Map<String, Object> taggers = ValueUtils.children(values, KEY_PARAM_TAGGERS);
        for (Map.Entry<String, Object> tagger : taggers.entrySet()) {
            this.configure(configuration.getOrCreateTagger(tagger.getKey()), (Map<String, Object>)((Map)ValueUtils.cast(tagger.getValue())));
        }
    }

    private void checkConfigValueKeys(Map<String, Object> values, String ... whiteKeys) {
        Set diff = CollectionUtils.difference(values.keySet(), Arrays.asList(whiteKeys));
        if (CollectionUtils.isNotEmpty((Collection)diff)) {
            log.warn("Configure configuration maybe have exception: unknown extra keys exist. [unknownKeys={}]", (Object)diff);
        }
    }
}

