/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassicBrokerConfigurationConfigurator
implements BrokerConfigurationConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassicBrokerConfigurationConfigurator.class);
    private static final String RESOURCE_KEY = "fit.properties";
    private final File libraryDirectory;
    private final File configDirectory;

    public ClassicBrokerConfigurationConfigurator(File libraryDirectory, File configDirectory) {
        this.libraryDirectory = (File)Validation.notNull((Object)libraryDirectory, (String)"The directory to store JARs cannot be null.", (Object[])new Object[0]);
        this.configDirectory = (File)Validation.notNull((Object)configDirectory, (String)"The directory to store config files cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public void configure(ConfigurableBrokerConfiguration destination, ConfigureMode mode) {
        Object[] libs = this.libraryDirectory.listFiles();
        if (ArrayUtils.isEmpty((Object[])libs)) {
            log.info("Skip to load broker configuration: No JAR file found in lib directory. [path={}]", (Object)FileUtils.path((File)this.libraryDirectory));
        } else {
            Stream.of(libs).filter(Objects::nonNull).filter(File::isFile).filter(FileUtils::isJar).map(this::configurator).forEach(configurator -> configurator.configure(destination, mode));
        }
        BrokerConfigurationConfigurator.file(new File(this.configDirectory, RESOURCE_KEY), ConfigurationReader.properties()).configure(destination, mode);
    }

    private BrokerConfigurationConfigurator configurator(File jar) {
        return BrokerConfigurationConfigurator.jar(jar, RESOURCE_KEY, ConfigurationReader.properties());
    }
}

