/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.ConfigurableGenericableConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableGenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurableTaggerConfiguration;
import com.huawei.fitframework.broker.conf.TaggerConfiguration;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurableTaggerConfiguration;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class DefaultConfigurableGenericableParamConfiguration
implements ConfigurableGenericableParamConfiguration {
    private final ConfigurableGenericableConfiguration parent;
    private final String name;
    private int index;
    private String type;
    private final Map<String, ConfigurableTaggerConfiguration> taggers;
    private final Object lock = new byte[0];

    public DefaultConfigurableGenericableParamConfiguration(ConfigurableGenericableConfiguration parent, String name) {
        this.parent = (ConfigurableGenericableConfiguration)Validation.notNull((Object)parent, (String)"The parent of a param configuration cannot be null.", (Object[])new Object[0]);
        this.name = Validation.notBlank((String)name, (String)"The name of a param configuration cannot be blank.", (Object[])new Object[0]);
        this.index = 0;
        this.type = "";
        this.taggers = new ConcurrentHashMap<String, ConfigurableTaggerConfiguration>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableGenericableParamConfiguration index(int index) {
        Object object = this.lock;
        synchronized (object) {
            this.index = index;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurableGenericableParamConfiguration type(String type) {
        Object object = this.lock;
        synchronized (object) {
            this.type = (String)ObjectUtils.nullIf((Object)type, (Object)"");
        }
        return this;
    }

    @Override
    public ConfigurableTaggerConfiguration getOrCreateTagger(String taggerId) {
        Validation.notBlank((String)taggerId, (String)"The id of tagger cannot be blank.", (Object[])new Object[0]);
        return this.taggers.computeIfAbsent(taggerId, key -> new DefaultConfigurableTaggerConfiguration(this, (String)key));
    }

    @Override
    public void removeTagger(String taggerId) {
        if (StringUtils.isNotBlank((String)taggerId)) {
            this.taggers.remove(taggerId);
        }
    }

    @Override
    public void remove() {
        this.parent.removeParam(this.name());
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public Collection<TaggerConfiguration> taggers() {
        return this.taggers.values().stream().map(TaggerConfiguration.class::cast).collect(Collectors.toList());
    }

    @Override
    public Optional<TaggerConfiguration> tagger(String taggerId) {
        if (StringUtils.isBlank((String)taggerId)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.taggers.get(taggerId));
    }
}

