/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigurationReader;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedResourceBrokerConfigurationConfigurator
implements BrokerConfigurationConfigurator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedResourceBrokerConfigurationConfigurator.class);
    private final ClassLoader loader;
    private final String resourceKey;
    private final ConfigurationReader reader;

    public EmbeddedResourceBrokerConfigurationConfigurator(ClassLoader loader, String resourceKey, ConfigurationReader reader) {
        this.loader = (ClassLoader)Validation.notNull((Object)loader, (String)"The class loader for embedded resource cannot be null.", (Object[])new Object[0]);
        this.resourceKey = Validation.notBlank((String)resourceKey, (String)"The key of embedded resource cannot be blank.", (Object[])new Object[0]);
        this.reader = (ConfigurationReader)Validation.notNull((Object)reader, (String)"The reader for embedded resource cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public void configure(ConfigurableBrokerConfiguration destination, ConfigureMode mode) {
        Enumeration<URL> resources = this.lookupResources();
        while (resources.hasMoreElements()) {
            this.configure(resources.nextElement(), destination, mode);
        }
    }

    private Enumeration<URL> lookupResources() {
        try {
            return this.loader.getResources(this.resourceKey);
        }
        catch (IOException e) {
            log.warn("Fail to lookup resource in class loader. [loader={}, resource={}]", (Object)this.loader, (Object)this.resourceKey);
            throw new IllegalStateException(StringUtils.format((String)"Fail to lookup resource in class loader. [loader={0}, resource={1}]", (Object[])new Object[]{this.loader, this.resourceKey}), e);
        }
    }

    private void configure(URL resourceUrl, ConfigurableBrokerConfiguration configuration, ConfigureMode mode) {
        Map<String, Object> values;
        try (InputStream in = resourceUrl.openStream();){
            values = this.reader.read(in);
        }
        catch (IOException e) {
            log.warn("Fail to load broker configuration from resource. [url={}]", (Object)resourceUrl.toExternalForm());
            throw new IllegalStateException(StringUtils.format((String)"Fail to load broker configuration from resource. [url={0}]", (Object[])new Object[]{resourceUrl.toExternalForm()}), e);
        }
        log.info("Accept broker configuration from embedded classloader. [loader={}, resource={}]", (Object)this.loader, (Object)this.resourceKey);
        BrokerConfigurationConfigurator.values(values).configure(configuration, mode);
    }
}

