/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.support;

import com.huawei.fitframework.broker.conf.BrokerConfigurationConfigurator;
import com.huawei.fitframework.broker.conf.ConfigurableBrokerConfiguration;
import com.huawei.fitframework.broker.conf.ConfigureMode;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.Map;

public class GenericableBrokerConfigurationConfigurator
implements BrokerConfigurationConfigurator {
    private final String genericableId;
    private final Map<String, Object> values;

    public GenericableBrokerConfigurationConfigurator(String genericableId, Map<String, Object> values) {
        this.genericableId = Validation.notBlank((String)genericableId, (String)"The id of genericable to configure broker configuration cannot be blank.", (Object[])new Object[0]);
        this.values = (Map)ObjectUtils.nullIf(values, Collections.emptyMap());
    }

    @Override
    public void configure(ConfigurableBrokerConfiguration destination, ConfigureMode mode) {
        Map<String, Map<String, Object>> genericables = Collections.singletonMap(this.genericableId, this.values);
        Map<String, Object> broker = Collections.singletonMap("genericables", genericables);
        BrokerConfigurationConfigurator.values(broker).configure(destination, mode);
    }
}

