/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.util;

import com.huawei.fitframework.broker.conf.util.support.DefaultMapAggregator;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;

@FunctionalInterface
public interface MapAggregator {
    public <V> Map<String, Object> aggregate(Collection<String> var1, Function<String, V> var2, Predicate<V> var3);

    default public <V> Map<String, Object> aggregate(Collection<String> keys, Function<String, V> mapper) {
        return this.aggregate(keys, mapper, null);
    }

    default public <V> Map<String, Object> aggregate(Map<String, V> origin, Predicate<V> predicate) {
        Map actual = (Map)ObjectUtils.nullIf(origin, Collections.emptyMap());
        return this.aggregate(actual.keySet(), actual::get, predicate);
    }

    default public <V> Map<String, Object> aggregate(Map<String, V> origin) {
        return this.aggregate(origin, null);
    }

    default public Map<String, Object> aggregate(Properties properties) {
        Properties actual = (Properties)ObjectUtils.nullIf((Object)properties, (Object)new Properties());
        return this.aggregate(properties.stringPropertyNames(), properties::getProperty);
    }

    public static MapAggregator create(char keySeparator) {
        return new DefaultMapAggregator(keySeparator);
    }
}

