/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.conf.util.support;

import com.huawei.fitframework.broker.conf.util.MapAggregator;
import com.huawei.fitframework.broker.conf.util.ValueUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultMapAggregator
implements MapAggregator {
    private final char keySeparator;

    public DefaultMapAggregator(char keySeparator) {
        this.keySeparator = keySeparator;
    }

    @Override
    public <V> Map<String, Object> aggregate(Collection<String> keys, Function<String, V> mapper, Predicate<V> predicate) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptyMap();
        }
        return this.aggregate0(keys, mapper, predicate);
    }

    private <V> Map<String, Object> aggregate0(Collection<String> keys, Function<String, V> mapper, Predicate<V> predicate) {
        HashMap<String, Object> aggregation = new HashMap<String, Object>();
        for (String key : keys) {
            V value = mapper.apply(key);
            if (!predicate.test(value)) continue;
            this.fill(aggregation, key, value);
        }
        return aggregation;
    }

    private <V> void fill(Map<String, Object> aggregation, String key, V value) {
        String[] paths = StringUtils.split((String)key, (char)this.keySeparator);
        HashMap values = aggregation;
        for (int i = 0; i < paths.length - 1; ++i) {
            String path = paths[i];
            Object next = values.get(path);
            if (next == null) {
                HashMap actual = new HashMap();
                values.put(path, actual);
                values = actual;
                continue;
            }
            if (next instanceof Map) {
                values = (HashMap)ValueUtils.cast(next);
                continue;
            }
            throw new IllegalStateException(StringUtils.format((String)"A value cannot have both value and children. [key={0}]", (Object[])new Object[]{StringUtils.join((char)'.', Arrays.stream(paths, 0, i + 1).collect(Collectors.toList()))}));
        }
        values.put(paths[paths.length - 1], value);
    }
}

