/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization;

import com.huawei.fit.sdk.context.entity.GlobalContext;
import lombok.Generated;

public class FitResponse<T> {
    public static final int CODE_UNKNOWN = -1;
    public static final String MSG_UNKNOWN = "unknown error";
    public static final int CODE_SUCCESS = 0;
    public static final String MSG_SUCCESS = "success";
    private static final String FIT_BIZ_EXCEPTION = "FitBizException";
    private T data;
    private Integer code;
    private String msg;
    private String errorType;
    private GlobalContext context;

    private FitResponse() {
    }

    public final boolean isSuccess() {
        return this.code == 0;
    }

    public final boolean notSuccess() {
        return !this.isSuccess();
    }

    public static <T> FitResponse<T> success() {
        return FitResponse.success(null);
    }

    public static <T> FitResponse<T> success(T data) {
        FitResponse<T> response = new FitResponse<T>();
        response.data = data;
        response.code = 0;
        response.msg = MSG_SUCCESS;
        response.errorType = "None";
        return response;
    }

    public static <T> FitResponse<T> fail() {
        return FitResponse.fail(-1, MSG_UNKNOWN, FIT_BIZ_EXCEPTION);
    }

    public static <T> FitResponse<T> fail(String errorMsg) {
        return FitResponse.fail(-1, errorMsg, FIT_BIZ_EXCEPTION);
    }

    public static <T> FitResponse<T> fail(int errCode, String errorMsg) {
        return FitResponse.fail(errCode, errorMsg, FIT_BIZ_EXCEPTION);
    }

    public static <T> FitResponse<T> fail(int errCode, String errorMsg, String errorType) {
        FitResponse<T> response = new FitResponse<T>();
        response.code = errCode;
        response.msg = errorMsg;
        response.errorType = errorType;
        return response;
    }

    @Generated
    public T getData() {
        return this.data;
    }

    @Generated
    public Integer getCode() {
        return this.code;
    }

    @Generated
    public String getMsg() {
        return this.msg;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public GlobalContext getContext() {
        return this.context;
    }

    @Generated
    public void setContext(GlobalContext context) {
        this.context = context;
    }
}

