/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.conf.startup.support;

import com.huawei.fitframework.conf.startup.PluginConfigBuilder;
import com.huawei.fitframework.conf.startup.StartupConfig;
import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import lombok.Generated;

public class DefaultPlugin
implements StartupConfig.Plugin {
    public static final int DEFAULT_SYSTEM_PLUGIN_LEVEL = 0;
    public static final int DEFAULT_USER_PLUGIN_LEVEL = 3;
    private final String name;
    private final File file;
    private final int level;
    private final File lib;
    private final File thirdParty;

    private DefaultPlugin(String name, File file, Integer level, File lib, File thirdParty) {
        this.name = Validation.notBlank((String)name, (String)"No plugin name.", (Object[])new Object[0]);
        this.file = FileUtils.canonicalize((File)((File)Validation.notNull((Object)file, (String)"No plugin file. [name={0}]", (Object[])new Object[]{this.name})));
        Validation.isTrue((boolean)this.file.isDirectory(), (String)"Plugin file is not a directory. [name={0}]", (Object[])new Object[]{this.name});
        this.level = (Integer)Validation.notNull((Object)level, (String)"No plugin level. [name={0}]", (Object[])new Object[]{this.name});
        this.lib = lib;
        this.thirdParty = thirdParty;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public File file() {
        return this.file;
    }

    @Override
    public int level() {
        return this.level;
    }

    @Override
    public File lib() {
        return this.lib;
    }

    @Override
    public File thirdParty() {
        return this.thirdParty;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultPlugin)) {
            return false;
        }
        DefaultPlugin other = (DefaultPlugin)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.level != other.level) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        File this$file = this.file;
        File other$file = other.file;
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        File this$lib = this.lib;
        File other$lib = other.lib;
        if (this$lib == null ? other$lib != null : !((Object)this$lib).equals(other$lib)) {
            return false;
        }
        File this$thirdParty = this.thirdParty;
        File other$thirdParty = other.thirdParty;
        return !(this$thirdParty == null ? other$thirdParty != null : !((Object)this$thirdParty).equals(other$thirdParty));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultPlugin;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.level;
        String $name = this.name;
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        File $file = this.file;
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        File $lib = this.lib;
        result = result * 59 + ($lib == null ? 43 : ((Object)$lib).hashCode());
        File $thirdParty = this.thirdParty;
        result = result * 59 + ($thirdParty == null ? 43 : ((Object)$thirdParty).hashCode());
        return result;
    }

    public static class Builder
    implements PluginConfigBuilder {
        private static final String KEY_NAME = "name";
        private static final String KEY_LOCATION = "location";
        private static final String KEY_ABSOLUTELY = "absolutely";
        private static final String KEY_LIB = "lib";
        private static final String KEY_THIRD_PARTY = "third-party";
        private static final String KEY_LEVEL = "level";
        private static final String LIB = "lib";
        private static final String THIRD_PARTY = "third-party";
        private String name;
        private File file;
        private Integer level;
        private File lib;
        private File thirdParty;

        public Builder(StartupConfig.Plugin plugin) {
            if (plugin != null) {
                this.name = plugin.name();
                this.file = plugin.file();
                this.level = plugin.level();
                this.lib = plugin.lib();
                this.thirdParty = plugin.thirdParty();
            }
        }

        public Builder(Map<String, Object> map, String workerDirectory, int defaultLevel) {
            if (MapUtils.isEmpty(map)) {
                return;
            }
            this.name = (String)ObjectUtils.cast((Object)map.get(KEY_NAME));
            String location = (String)ObjectUtils.cast((Object)map.get(KEY_LOCATION));
            boolean isAbsolute = Boolean.parseBoolean((String)ObjectUtils.cast((Object)map.get(KEY_ABSOLUTELY)));
            this.file = isAbsolute ? new File(location) : new File(workerDirectory, location);
            Path rootPath = FileUtils.canonicalize((File)this.file).toPath();
            String libDirectory = (String)ObjectUtils.cast((Object)map.get("lib"));
            String thirdPartyDirectory = (String)ObjectUtils.cast((Object)map.get("third-party"));
            this.lib = libDirectory == null ? rootPath.resolve("lib").toFile() : rootPath.resolve(libDirectory).toFile();
            this.thirdParty = thirdPartyDirectory == null ? rootPath.resolve("third-party").toFile() : rootPath.resolve(thirdPartyDirectory).toFile();
            this.level = Integer.parseInt((String)ObjectUtils.nullIf((Object)ObjectUtils.cast((Object)map.get(KEY_LEVEL)), (Object)String.valueOf(defaultLevel)));
        }

        @Override
        public PluginConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public PluginConfigBuilder absoluteLocation(String location) {
            this.file = new File(location);
            return this;
        }

        @Override
        public PluginConfigBuilder lib(String lib) {
            this.lib = new File(lib);
            return this;
        }

        @Override
        public PluginConfigBuilder thirdParty(String thirdParty) {
            this.thirdParty = new File(thirdParty);
            return this;
        }

        @Override
        public PluginConfigBuilder relativeLocation(String workerDirectory, String location) {
            this.file = new File(workerDirectory, location);
            return this;
        }

        @Override
        public PluginConfigBuilder level(int level) {
            this.level = level;
            return this;
        }

        @Override
        public PluginConfigBuilder system() {
            this.level = 0;
            return this;
        }

        @Override
        public PluginConfigBuilder user() {
            this.level = 3;
            return this;
        }

        @Override
        public StartupConfig.Plugin build() {
            Path rootPath = FileUtils.canonicalize((File)this.file).toPath();
            if (this.lib == null) {
                this.lib = rootPath.resolve("lib").toFile();
            }
            if (this.thirdParty == null) {
                this.thirdParty = rootPath.resolve("third-party").toFile();
            }
            return new DefaultPlugin(this.name, this.file, this.level, this.lib, this.thirdParty);
        }
    }
}

